<?php
$first_name = $order->get_billing_first_name(); 
$last_name  = $order->get_billing_last_name();
$full_name = $first_name .' '. $last_name;
$email     = $order->get_billing_email(); 
$phone     = $order->get_billing_phone();
$orders_list = get_orders_by_phone_number( $phone );
$available_statuses = wc_get_order_statuses();

if ( count($orders_list) > 1 ) {

    // Initialize counts dynamically for all statuses
    $order_counts = ['all' => 0]; // Always include 'all'
    foreach ( $available_statuses as $status_key => $status_label ) {
        $order_counts[ str_replace( 'wc-', '', $status_key ) ] = 0; // Strip 'wc-' prefix
    }

    foreach ( $orders_list as $order ) {
        $status = $order->get_status();
        if ( isset( $order_counts[$status] ) ) {
            $order_counts[$status]++;
        }
        $order_counts['all']++;
    }

    $statuses = array_unique( array_map( function($order) { return $order->get_status(); }, $orders_list ) );
    $status_links = ['all' => $order_counts['all']]; // Include 'all' link
    foreach ( $order_counts as $status => $count ) {
        if ( $status !== 'all' && $count > 0 ) {
            $status_links[$status] = $count;
        }
    }

    ?>
    <div class="order-detect-modal-dialog" id="order-detect-multi-order-tracker-metabox">
        <div class="order-detect-modal">
            <div class="order-detect-modal-content-two">
                <section class="order-detect-modal-main" role="main">
                    <div class="wc-order-preview-addresses order-detect-preview-parent">
                        <div class="order-status-area">
                            <ul class="subsubsub">
                                <?php foreach ( $status_links as $status => $count ) : ?>
                                    <?php if ( $count > 0 ) : ?>
                                        <li class="<?php echo esc_attr( 'wc-' . $status ); ?>">
                                            <a href="#" class="<?php echo $status === 'all' ? 'current' : ''; ?>" data-status="<?php echo esc_attr( $status ); ?>">
                                                <?php echo esc_html( ucfirst( str_replace( '-', ' ', $status ) ) ); ?>
                                                <span class="count">(<?php echo esc_html( $count ); ?>)</span>
                                            </a>
                                            <?php if ( $status !== array_key_last( $status_links ) ) : ?>
                                                |
                                            <?php endif; ?>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>    
                        <div class="order-detect-header">
                            <div class="od-header-item"><?php esc_html_e( 'Order', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Date', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Status', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Total', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Action', 'order-detect' ); ?></div>
                        </div>
                        <div class="wc-order-preview-table-wrapper">
                            <?php if ( count( $orders_list ) ): ?>
                                <?php foreach ( $orders_list as $order ) : ?>
                                    <div class="order-detect-row order-status-<?php echo esc_attr( $order->get_status() ); ?>">
                                        <div class="od-customer-name" style="width: 100%;"><?php
                                            $buyer = '';
                                            if ( $order->get_billing_first_name() || $order->get_billing_last_name() ) {
                                                $buyer = trim( sprintf( _x( '%1$s %2$s', 'full name', 'woocommerce' ), $order->get_billing_first_name(), $order->get_billing_last_name() ) );
                                            } elseif ( $order->get_billing_company() ) {
                                                $buyer = trim( $order->get_billing_company() );
                                            } elseif ( $order->get_customer_id() ) {
                                                $user  = get_user_by( 'id', $order->get_customer_id() );
                                                $buyer = ucwords( $user->display_name );
                                            }
                                            echo '<strong>#' . esc_attr( $order->get_order_number() ) . ' ' . esc_html( $buyer ) . '</strong>'; 
                                        ?></div>
                                        <div class="od-purchase-date" style="width: 100%;"><?php echo date_i18n( 'M j, Y', strtotime( $order->get_date_created() ) ); ?></div>
                                        <div class="od-status" style="width: 100%;"><?php echo wc_get_order_status_name( $order->get_status() ); ?></div>
                                        <div class="od-purchase-price" style="width: 100%;"><?php echo wp_strip_all_tags( wc_price( $order->get_total() ) ); ?></div>
                                        <div class="od-action" style="width: 100%;">
                                            <?php 
                                                $order_link = admin_url( 'post.php?post=' . $order->get_id() . '&action=edit' );
                                                echo '<a href="' . esc_url( $order_link ) . '" class="button button-primary button-large od-view-order" target="_blank">' . __( "View", "order-detect" ) . '</a>';
                                            ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="order-detect-row">
                                    <div class="od-no-orders"><?php esc_html_e( 'Other orders not found!', 'order-detect' ); ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <div class="order-detect-modal-backdrop"></div>
    </div>
    <script>
        jQuery(document).ready(function($) {
            // Cache the relevant elements
            const odMultiOrderTrackerMetabox = $('#order-detect-multi-order-tracker-metabox');
            const statusLinks = odMultiOrderTrackerMetabox.find('.order-status-area a[data-status]');
            const rowsContainer = odMultiOrderTrackerMetabox.find('.wc-order-preview-table-wrapper');
            const rows = rowsContainer.find('.order-detect-row');

            // Event handler for status link clicks
            statusLinks.on('click', function(e) {
                e.preventDefault();

                const selectedStatus = $(this).data('status');
                if (rows.length) {
                    rows.each(function() {
                        const row = $(this);
                        // Extract the full order-status class (including hyphens)
                        const rowClassMatch = row.attr('class').match(/order-status-[\w-]+/);
                        const rowStatusClass = rowClassMatch ? rowClassMatch[0] : '';                                    
                    
                        if (selectedStatus === 'all' || rowStatusClass === `order-status-${selectedStatus}`) {
                            row.show();
                        } else {
                            row.hide();
                        }
                    });

                    // Update the 'current' class for the active status link
                    statusLinks.removeClass('current');
                    $(this).addClass('current');
                }
            });
        });
    </script>
    <?php
} else {
    ?>
    <div class="order-detect-modal-dialog" id="order-detect-multi-order-tracker-metabox">
        <div class="order-detect-modal">
            <div class="order-detect-modal-content-two">
                <section class="order-detect-modal-main" role="main">
                    <div class="wc-order-preview-addresses order-detect-preview-parent">
                        <div class="order-status-area">
                        </div>
                        <div class="order-detect-header">
                            <div class="od-header-item"><?php esc_html_e( 'Order', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Date', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Status', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Total', 'order-detect' ); ?></div>
                            <div class="od-header-item"><?php esc_html_e( 'Action', 'order-detect' ); ?></div>
                        </div>
                        <div class="wc-order-preview-table-wrapper">
                            <div class="order-detect-row">
                                <div class="od-no-orders"><?php esc_html_e( 'Other orders not found!', 'order-detect' );?></div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <div class="order-detect-modal-backdrop"></div>
    </div>
    <?php
}