<?php
namespace OrderDetect\Services;
use OrderDetect\Helper;

class MultipleOrderTrack {
    protected static $_instance = null;

    public function __construct() {
        if( !Helper::check_license( wp_parse_args( get_option('orderdetect_license') ) ) ) return;
        add_filter( 'manage_edit-shop_order_columns', array( $this, 'add_multi_order_tracking_column_header'), PHP_INT_MAX );
        add_filter( "manage_woocommerce_page_wc-orders_columns", array( $this, 'add_multi_order_tracking_column_header'), PHP_INT_MAX );
        add_filter( "manage_edit-woocommerce_page_wc-orders_columns", array( $this, 'add_multi_order_tracking_column_header'), PHP_INT_MAX );
        add_action( 'manage_shop_order_posts_custom_column', array( $this, 'multi_order_tracking_column_content' ), PHP_INT_MAX, 2 );
        add_action( "manage_woocommerce_page_wc-orders_custom_column", array( $this, 'multi_order_tracking_column_content' ), PHP_INT_MAX, 2 );
        add_action( "manage_woocommerce_page_wc-orders_posts_custom_column", array( $this, 'multi_order_tracking_column_content' ), PHP_INT_MAX, 2 );
        add_action( 'woocommerce_thankyou', array( $this, 'od_track_multiple_order'), PHP_INT_MAX, 1);
        add_action( 'add_meta_boxes', array( $this, 'od_multiple_order_tracker_metabox'), PHP_INT_MAX );

    }

    public function add_multi_order_tracking_column_header( $columns ) {
        $new_columns = array();

        foreach ( $columns as $column_name => $column_info ) {
            $new_columns[ $column_name ] = $column_info;
            if ( 'order_number' === $column_name ) {
                $new_columns['order_track'] = __( '', 'order-detect' );
            }
        }
        return $new_columns;
    }

    public function multi_order_tracking_column_content( $column, $order ) {

        if ( 'order_track' !== $column ) {
            return;
        }

        if ( $order instanceof \WC_Order ) {
            $id = $order->get_id();
            $phone_number = $order->get_billing_phone();
        } else {
            $id = $order;
            $order = wc_get_order($id);
            $phone_number = $order->get_billing_phone();
        }
        
        $cached_order_ids = get_post_meta($phone_number, $phone_number . '_multi_order', true);

        if ( 'order_track' === $column  ) {
            if ( ! empty( $cached_order_ids ) && is_array( $cached_order_ids ) && count( $cached_order_ids ) > 1 ) {
                ?>  
                    <style>
                        #multi-order-preview-<?php echo $id; ?>::before { font-family: Dashicons !important; content: "\f164" !important; }
                    </style>
                <?php
                echo '<a href="#" id="multi-order-preview-'.$id.'" class="multi-order-preview" data-order-id="'.$id.'" data-sync="yes" title="Multi-Order Track"></a>';
                $first_name = $order->get_billing_first_name(); 
                $last_name  = $order->get_billing_last_name();
                $full_name = $first_name .' '. $last_name;
                $email     = $order->get_billing_email(); 
                $phone     = $order->get_billing_phone();
                $orders = [];
                foreach ($cached_order_ids as $order_id) {
                    $order = wc_get_order($order_id);
                    if ($order) {
                        $orders[] = $order;
                    }
                }
                echo generate_multi_order_tracking_modal($id, $full_name, $email, $phone, $orders);

            } 
            // else {
                // error_log('Not done phone_number: '. $phone_number);
                // echo '<a href="#" id="multi-order-preview-'.$id.'" class="multi-order-preview" data-order-id="'.$id.'" data-sync="no" title="Multi-Order Track">Loading...</a>';
            // }
        }
    }

    public function od_track_multiple_order( $order_id ) {
        $order = wc_get_order( $order_id );
        if (!$order) return;
    
        $phone_number = $order->get_billing_phone();
        if (!$phone_number) return;
    
        // Get existing order data array for this phone number
        $existing_orders = get_post_meta($phone_number, $phone_number . '_multi_order', true);
        $order_array = is_array($existing_orders) ? $existing_orders : array();
    
        // Add new order ID to the array if it doesn't exist
        if (!in_array($order_id, $order_array)) {
            $order_array[] = $order_id;
            update_post_meta($phone_number, $phone_number . '_multi_order', $order_array);
        }
    }

    public function od_multiple_order_tracker_metabox() {
        $screen_id = class_exists('Automattic\\WooCommerce\\Admin\\Features\\Features') ? 'woocommerce_page_wc-orders' : 'shop_order';
        add_meta_box(
            'od-multiple-order-track',
            __('Multi-Order Track', 'order-detect'),
            array( $this, 'display_multiple_order_list'),
            $screen_id,
            'normal',
            'high'
        );
    }

    public function display_multiple_order_list($post_or_order) {
        $order = $post_or_order instanceof \WC_Order ? $post_or_order : wc_get_order( $post_or_order );
        if ( $order instanceof \WC_Order ) {
            $template = ORDERDETECT_VIEWS . '/multi-order-tracker-metabox.php';
            if (file_exists($template)) {
                include $template;
            }
        }
    }

    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}

