<?php

namespace OrderDetect;

class Installer {

    public function run() {
        $this->add_version();
        $this->create_od_otp_log_table();
        $this->create_phone_blocks_table();
        $this->create_device_blocks_table();
        $this->create_ip_address_table();
    }

    public function add_version() {
        $installed = get_option('orderdetect_installed');

        if (!$installed) {
            update_option('orderdetect_installed', time());
        }

        update_option('orderdetect_version', ORDERDETECT_VERSION);
    }

    public function create_od_otp_log_table() {
        global $wpdb;
        $table_name = $wpdb->prefix . 'od_otp_log';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $table_name (
            id mediumint(9) NOT NULL AUTO_INCREMENT,
            phone_number varchar(15) NOT NULL,
            code varchar(6) NOT NULL,
            expires_at datetime NOT NULL,
            is_verified int(1) DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            UNIQUE KEY phone_number (phone_number)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        $is_error = empty($wpdb->last_error);
        return $is_error;
    }
    
    public function create_phone_blocks_table() {
        global $wpdb;
        $table_one = $wpdb->prefix . 'od_phone_blocks';
        $table_two = $wpdb->prefix . 'od_phone_device';
        $table_three = $wpdb->prefix . 'od_phone_ip';
        $charset_collate = $wpdb->get_charset_collate();

        $table_one_sql = "CREATE TABLE IF NOT EXISTS $table_one (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            phone_number varchar(15) NOT NULL,
            count int(11) DEFAULT 0,
            block_status int(1) DEFAULT 1,
            blocked_until datetime DEFAULT NULL,
            order_id bigint(20) NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY phone_number (phone_number)
        ) $charset_collate;";

        $table_two_sql = "CREATE TABLE IF NOT EXISTS $table_two (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            phone_number varchar(15) NOT NULL,
            device_id varchar(255) NOT NULL,
            user_agent text NOT NULL,
            order_id bigint(20) NOT NULL,
            order_created_gmt datetime NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        $table_three_sql = "CREATE TABLE IF NOT EXISTS $table_three (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            phone_number varchar(15) NOT NULL,
            ip_address varchar(45) NOT NULL,
            order_id bigint(20) NOT NULL,
            order_created_gmt datetime NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($table_one_sql);
        dbDelta($table_two_sql);
        dbDelta($table_three_sql);

        $is_error = empty($wpdb->last_error);
        return $is_error;
    }

    public function create_device_blocks_table() {
        global $wpdb;
        $table_one = $wpdb->prefix . 'od_device_blocks';
        $table_two = $wpdb->prefix . 'od_device_phone';
        $table_three = $wpdb->prefix . 'od_device_ip';
        $charset_collate = $wpdb->get_charset_collate();

        $table_one_sql = "CREATE TABLE IF NOT EXISTS $table_one (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            device_id varchar(255) NOT NULL,
            count int(11) DEFAULT 0,
            block_status int(1) DEFAULT 1,
            blocked_until datetime DEFAULT NULL,
            order_id bigint(20) NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY device_id (device_id)
        ) $charset_collate;";

        $table_two_sql = "CREATE TABLE IF NOT EXISTS $table_two (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            device_id varchar(255) NOT NULL,
            user_agent text NOT NULL,
            phone_number varchar(15) NOT NULL,
            order_id bigint(20) NULL,
            order_created_gmt datetime NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        $table_three_sql = "CREATE TABLE IF NOT EXISTS $table_three (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            device_id varchar(255) NOT NULL,
            user_agent text NOT NULL,
            ip_address varchar(45) NOT NULL,
            order_id bigint(20) NULL,
            order_created_gmt datetime NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($table_one_sql);
        dbDelta($table_two_sql);
        dbDelta($table_three_sql);

        $is_error = empty($wpdb->last_error);
        return $is_error;
    }

    public function create_ip_address_table() {
        global $wpdb;
        $table_one = $wpdb->prefix . 'od_ip_blocks';
        $table_two = $wpdb->prefix . 'od_ip_phone';
        $table_three = $wpdb->prefix . 'od_ip_device';
        $charset_collate = $wpdb->get_charset_collate();

        $table_one_sql = "CREATE TABLE IF NOT EXISTS $table_one (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            ip_address varchar(45) NOT NULL,
            count int(11) DEFAULT 0,
            block_status int(1) DEFAULT 1,
            blocked_until datetime DEFAULT NULL,
            order_id bigint(20) NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY ip_address (ip_address)
        ) $charset_collate;";

        $table_two_sql = "CREATE TABLE IF NOT EXISTS $table_two (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            ip_address varchar(45) NOT NULL,
            phone_number varchar(15) NOT NULL,
            order_id bigint(20) NULL,
            order_created_gmt datetime NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        $table_three_sql = "CREATE TABLE IF NOT EXISTS $table_three (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            ip_address varchar(45) NOT NULL,
            device_id varchar(255) NOT NULL,
            user_agent text NOT NULL,
            order_id bigint(20) NULL,
            order_created_gmt datetime NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($table_one_sql);
        dbDelta($table_two_sql);
        dbDelta($table_three_sql);

        $is_error = empty($wpdb->last_error);
        return $is_error;
    }
}
