<?php

namespace OrderDetect;

use Automattic\WooCommerce\Utilities\OrderUtil;

class Helper
{

    private static $hpos_enabled = null;

    public static function check_license($settings)
    {
        if (empty($settings)) {
            return false;
        }

        $key = array_key_exists('key', $settings) ? $settings['key'] : '';
        $expires = array_key_exists('expires', $settings) ? $settings['expires'] : '';
        if (!empty($key) && !empty($expires)) {
            $current_date = current_time('mysql');
            if (Helper::decrypt_data($expires, 'yE7VLwfyweOTwWyxQgjNcxgArStNUARmkHVvsF3j4eU=', 'sq/gQejtmYczi99rYa61hA==') === "lifetime") {
                return true;
            }
            if (strtotime($current_date) > strtotime(Helper::decrypt_data($expires, 'yE7VLwfyweOTwWyxQgjNcxgArStNUARmkHVvsF3j4eU=', 'sq/gQejtmYczi99rYa61hA=='))) {
                return false;
            }
        }
        return true;
    }

    public static function is_valid_Bangladeshi_phone_number($phoneNumber)
    {
        $regex = '/^(?:\+?88)?01[1-9]\d{8}$/';
        return preg_match($regex, $phoneNumber);
    }

    public static function generate_unique_otp_for_phone($phone_number, $length = 4)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'od_otp_log';

        do {
            $random_number = rand(0, 9999);
            $otp = str_pad($random_number, $length, '0', STR_PAD_LEFT);

            $exists = $wpdb->get_var($wpdb->prepare(
                "SELECT COUNT(*) FROM $table_name WHERE phone_number = %s AND code = %s",
                $phone_number,
                $otp
            ));
        } while ($exists);
        return $otp;
    }

    public static function generate_otp($phone_number)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'od_otp_log';
        $otp = Helper::generate_unique_otp_for_phone($phone_number);
        date_default_timezone_set('Asia/Dhaka');
        $expires_at = date('Y-m-d H:i:s', strtotime('+15 minutes'));

        $wpdb->replace(
            $table_name,
            array(
                'phone_number' => $phone_number,
                'code' => $otp,
                'expires_at' => $expires_at,
            ),
            array(
                '%s',
                '%s',
                '%s'
            )
        );

        return $otp;
    }

    public static function verify_otp($phone_number, $otp)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'od_otp_log';

        date_default_timezone_set('Asia/Dhaka');
        $current_time = date('Y-m-d H:i:s');
        $result = $wpdb->get_row($wpdb->prepare(
            "SELECT id, phone_number, code, expires_at, is_verified, created_at FROM $table_name WHERE phone_number = %s AND code = %s AND expires_at > %s",
            $phone_number,
            $otp,
            $current_time
        ));

        return (bool) $result;
    }

    public static function set_phone_number_verified($phone_number)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'od_otp_log';
        $wpdb->update(
            $table_name,
            array('is_verified' => true),
            array('phone_number' => $phone_number)
        );
    }

    public static function is_phone_number_verified($phone_number)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'od_otp_log';
        $sql = $wpdb->prepare(
            "SELECT COUNT(*) FROM $table_name WHERE phone_number = %s AND is_verified = %d",
            $phone_number,
            1
        );

        $count = $wpdb->get_var($sql);
        return $count > 0;
    }

    public static function send_request($url, $api_key, $method = 'GET', $postfields = [])
    {

        $args = [
            'method'    => 'GET',
            'timeout'   => 9999,
            'sslverify' => false,
            'headers'   => [],
            'body'      => $postfields
        ];

        $request = wp_remote_post($url, $args);

        if (is_wp_error($request) || wp_remote_retrieve_response_code($request) != 200) {
            return false;
        }

        return wp_remote_retrieve_body($request);
    }

    public static function update_balance()
    {
        global $odSmsProvider;
        $default_balance = [
            'greenweb' => 0.00,
            'alpha' => 0.00,
            'dianahost' => 0.00,
            'mimsms' => 0.00,
            'bulksmsbd' => 0.00,
        ];
        $sms_balance = get_option('orderdetect_sms_balance', $default_balance);

        $settings = wp_parse_args(get_option('orderdetect_settings', array(
            'sms_provider' => '',
            'sms_api_key' => array(
                'greenweb' => '',
                'alpha' => '',
                'dianahost' => '',
                'mimsms' => '',
                'bulksmsbd' => ''
            ),
            'mimsms_sender_id' => '',
'mimsms_username' => '',
            'bulksmsbd_sender_id' => '',
            'enable_otp' => 0,
            'checkout_otp_message' => '',
            'dianahost_sender_id' => '',
            'enable_invoice' => 0,
            'enable_packing_slip' => 0,
            'invoice_packing_slip_logo' => '',
            'business_name' => '',
            'enable_footer_text' => 0,
            'footer_text_heading' => '',
            'footer_text_details' => '',
            'delivery_partner' => '',
            'primary_color' => '#000'
        )));
        $endpoint = $odSmsProvider[$settings['sms_provider']];
        $api_key = $settings["sms_api_key"][$settings['sms_provider']];
        $orderdetect_settings = get_option('orderdetect_settings');
        $mim_user_name = $orderdetect_settings['mimsms_username'];

        if ("greenweb" === $settings['sms_provider']) {
            $endpoint .= "/g_api.php?token=" . $api_key . "&balance";
        } else if ("alpha" === $settings['sms_provider']) {
            $endpoint .= "/user/balance?api_key=" . $api_key . "";
        } else if ("dianahost" === $settings['sms_provider']) {
            $endpoint .= "/balance";
        } else if ("mimsms" === $settings['sms_provider']) {
            $endpoint .= "/SmsSending/balanceCheck?userName=".$mim_user_name."&Apikey=" . $api_key . "";
        } else if ("bulksmsbd" === $settings['sms_provider']) {
            $endpoint .= "/getBalanceApi?api_key=" . $api_key . "";
        }

        $headers = [
            "Authorization: Bearer $api_key",
            "Content-Type: application/json",
        ];






        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint);

        if ("dianahost" === $settings['sms_provider']) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $balanceResponse = curl_exec($ch);

        if ($balanceResponse !== false) {

            if ("greenweb" === $settings['sms_provider']) {
                if (strpos($balanceResponse, 'Error:') !== false) {
                    error_log('Error: ' . $balanceResponse);
                } else {
                    $sms_balance['greenweb'] = strip_tags($balanceResponse);
                }
            } else if ("alpha" === $settings['sms_provider']) {
                $responseArray = json_decode($balanceResponse, true);
                if ($responseArray['error'] == 0 && isset($responseArray['data']['balance'])) {
                    $balance = $responseArray['data']['balance'];
                    $sms_balance['alpha'] = number_format($balance, 2);
                } else {
                    error_log('API Error: ' . $responseArray['msg']);
                }
            } else if ("dianahost" === $settings['sms_provider']) {
                $responseArray = json_decode($balanceResponse, true);
                if ($responseArray['status'] == "success" && isset($responseArray['data']['remaining_unit'])) {
                    $balance = $responseArray['data']['remaining_unit'];
                    $sms_balance['dianahost'] = number_format($balance, 2);
                } else {
                    error_log('API Error: ' . $responseArray['msg']);
                }
            }  else if ("mimsms" === $settings['sms_provider']) {
                $responseArray = json_decode($balanceResponse, true);
                if ($responseArray['statusCode'] == 200 && isset($responseArray['responseResult'])) {
                    $balance = $responseArray['responseResult'];
                    $sms_balance['mimsms'] = number_format($balance, 2);
                } else {
                    error_log('API Error: ' . $responseArray['msg']);
                }
            }  else if ("bulksmsbd" === $settings['sms_provider']) {
                $responseArray = json_decode($balanceResponse, true);
                if ($responseArray['response_code'] == 202 && isset($responseArray['balance'])) {
                    $balance = $responseArray['balance'];
                    $sms_balance['bulksmsbd'] = number_format($balance, 2);
                } else {
                    error_log('API Error: ' . $responseArray['msg']);
                }
            }

            update_option('orderdetect_sms_balance', $sms_balance);
        }
    }

    public static function send_sms_balance_notification($sms_balance = null)
    {

        $settings = wp_parse_args(get_option('orderdetect_settings', array(
            'sms_provider' => '',
            'sms_api_key' => array(
                'greenweb' => '',
                'alpha' => '',
                'dianahost' => '',
                'mimsms' => '',
                'bulksmsbd' => ''
            ),
            'mimsms_sender_id' => '',
'mimsms_username' => '',
            'bulksmsbd_sender_id' => '',
            'enable_otp' => 0,
            'checkout_otp_message' => '',
            'dianahost_sender_id' => '',
            'enable_invoice' => 0,
            'enable_packing_slip' => 0,
            'invoice_packing_slip_logo' => '',
            'business_name' => '',
            'enable_footer_text' => 0,
            'footer_text_heading' => '',
            'footer_text_details' => '',
            'delivery_partner' => '',
            'primary_color' => '#000'
        )));
        $sms_balance = wp_parse_args(get_option('orderdetect_sms_balance', [
            'greenweb' => 0.00,
            'alpha' => 0.00,
            'dianahost' => 0.00,
            'mimsms' => 0.00,
            'bulksmsbd' => 0.00,
        ]));

        $balance = $sms_balance[$settings['sms_provider']];

        if ($balance <= 50 && ($balance == 50 || $balance == 40 || $balance == 30 || $balance == 20 || $balance == 10 || $balance == 2)) {
            $to = get_option('admin_email');
            $subject = 'Low SMS Balance Notification';
            $message = "Dear shop owner,\n\n";
            $message .= "This is to inform you that your SMS balance has reached " . $balance . " taka.\n";
            $message .= "Please refill your SMS balance to ensure uninterrupted service for your customers.\n\n";
            $message .= "Current SMS balance: " . $balance . " taka\n\n";
            $message .= "Best regards,\n";
            $message .= "OrderDetect";

            wp_mail($to, $subject, $message);
        }
    }

    public static function encrypt_data($target_data, $key = ORDERDETECT_ENCRYPTION_KEY, $iv = ORDERDETECT_IV)
    {
        $cipher_method = 'aes-256-cbc';
        $encrypted = openssl_encrypt($target_data, $cipher_method, base64_decode($key), 0, base64_decode($iv));
        return base64_encode($encrypted);
    }

    public static function decrypt_data($encrypted_data, $key = ORDERDETECT_ENCRYPTION_KEY, $iv = ORDERDETECT_IV)
    {
        $cipher_method = 'aes-256-cbc';
        $decrypted = openssl_decrypt(base64_decode($encrypted_data), $cipher_method, base64_decode($key), 0, base64_decode($iv));
        return $decrypted;
    }

    public static function mask_string($input)
    {
        $length = strlen($input);
        if ($length <= 8) {
            return $input;
        }

        $first_part = substr($input, 0, 4);
        $last_part = substr($input, -4);
        return $first_part . str_repeat('*', $length - 8) . $last_part;
    }

    public static function validate_and_format_phone_number($phone)
    {

        $phone = preg_replace('/\D/', '', $phone);

        if (strlen($phone) == 11) {
            if ($phone[0] == '0') {
                $phone = '880' . substr($phone, 1);
            }
        } elseif (strlen($phone) == 13) {
            if (substr($phone, 0, 3) != '880') {
                $phone = '';
            }
        } else {
            $phone = '';
        }

        return $phone;
    }

    public static function is_wc_hpos_enabled(){
        return get_option('woocommerce_custom_orders_table_enabled') === 'yes';
    }

    public static function get_last_order_by_phone($phone_number) {
        global $wpdb;

        $table_name = $wpdb->prefix . 'od_identifier_relations';
        return $wpdb->get_row(
            $wpdb->prepare(
                "SELECT order_id FROM {$table_name} 
                 WHERE phone_number = %s 
                 ORDER BY order_created_gmt DESC LIMIT 1",
                $phone_number
            )
        );
    }

    public static function get_order_count_by_phone($phone_number) {
        global $wpdb;
        
        $table_name = $wpdb->prefix . 'od_identifier_relations';
        return $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM {$table_name} 
                 WHERE phone_number = %s",
                $phone_number
            )
        );
    }

    public static function get_last_order_by_device($device_id) {
        global $wpdb;
        
        $table_name = $wpdb->prefix . 'od_identifier_relations';
        return $wpdb->get_row(
            $wpdb->prepare(
                "SELECT order_id FROM {$table_name} 
                 WHERE user_agent = %s 
                 ORDER BY order_created_gmt DESC LIMIT 1",
                $device_id
            )
        );
    }

    public static function get_order_count_by_device($device_id) {
        global $wpdb;
        
        $table_name = $wpdb->prefix . 'od_identifier_relations';
        return $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM {$table_name} 
                 WHERE user_agent = %s",
                $device_id
            )
        );
    }

    public static function get_last_order_by_ip($ip_address) {
        global $wpdb;
        
        $table_name = $wpdb->prefix . 'od_identifier_relations';
        return $wpdb->get_row(
            $wpdb->prepare(
                "SELECT order_id FROM {$table_name} 
                 WHERE ip_address = %s 
                 ORDER BY order_created_gmt DESC LIMIT 1",
                $ip_address
            )
        );
    }

    public static function get_order_count_by_ip($ip_address) {
        global $wpdb;
        
        $table_name = $wpdb->prefix . 'od_identifier_relations';
        return $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM {$table_name} 
                 WHERE ip_address = %s",
                $ip_address
            )
        );
    }
    
}
