<?php

/**
 * Checkout Payment Section
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/payment.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 */

defined('ABSPATH') || exit;

if (!wp_doing_ajax()) {
	do_action('woocommerce_review_order_before_payment');
}
$settings = wp_parse_args(get_option('orderdetect_settings', array(
	'sms_provider' => '',
	'sms_api_key' => array(
		'greenweb' => '',
		'alpha' => '',
		'dianahost' => '',
		'mimsms' => '',
		'bulksmsbd' => ''
	),
	'mimsms_sender_id' => '',
'mimsms_username' => '',
	'bulksmsbd_sender_id' => '',
	'enable_otp' => 0,
	'checkout_otp_message' => '',
	'dianahost_sender_id' => '',
	'enable_invoice' => 0,
	'enable_packing_slip' => 0,
	'invoice_packing_slip_logo' => '',
	'business_name' => '',
	'enable_footer_text' => 0,
	'footer_text_heading' => '',
	'footer_text_details' => '',
	'delivery_partner' => '',
	'primary_color' => '#000'
)));
?>
<div id="payment" class="woocommerce-checkout-payment">
	<?php if (WC()->cart->needs_payment()) : ?>
		<ul class="wc_payment_methods payment_methods methods">
			<?php
			if (!empty($available_gateways)) {
				foreach ($available_gateways as $gateway) {
					wc_get_template('checkout/payment-method.php', array('gateway' => $gateway));
				}
			} else {
				echo '<li>';
					wc_print_notice(apply_filters('woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__('Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce') : esc_html__('Please fill in your details above to see available payment methods.', 'woocommerce')), 'notice'); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment
				echo '</li>';
			}
			?>
		</ul>
	<?php endif; ?>
	<div class="form-row place-order">
		<noscript>
			<?php
			/* translators: $1 and $2 opening and closing emphasis tags respectively */
			printf(esc_html__('Since your browser does not support JavaScript, or it is disabled, please ensure you click the %1$sUpdate Totals%2$s button before placing your order. You may be charged more than the amount stated above if you fail to do so.', 'woocommerce'), '<em>', '</em>');
			?>
			<br /><button type="submit" class="button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="woocommerce_checkout_update_totals" value="<?php esc_attr_e('Update totals', 'woocommerce'); ?>"><?php esc_html_e('Update totals', 'woocommerce'); ?></button>
		</noscript>

		<?php wc_get_template('checkout/terms.php'); ?>

		<?php do_action('woocommerce_review_order_before_submit'); ?>

		<?php
			if ( 
				( ! empty( $settings['enable_otp'] ) &&  $settings['enable_otp'] == 1 && ! empty( $settings['checkout_otp_message'] ) ) || 
				( get_option('od_phone_block_enabled') || get_option('od_device_block_enabled') || get_option('od_ip_block_enabled') ) ||
				( ! empty(get_option('blocked_ips')) || ! empty(get_option('blocked_phones')) )
			) {
				echo apply_filters('woocommerce_order_button_html', '<button type="button" class="button alt show-otp-popup' . esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : '') . '" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr($order_button_text) . '" data-value="' . esc_attr($order_button_text) . '">' . esc_html($order_button_text) . '</button>');
			} else {
				echo apply_filters('woocommerce_order_button_html', '<button type="submit" class="button alt' . esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : '') . '" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr($order_button_text) . '" data-value="' . esc_attr($order_button_text) . '">' . esc_html($order_button_text) . '</button>'); // @codingStandardsIgnoreLine
			}
		?>

		<?php do_action('woocommerce_review_order_after_submit'); ?>

		<?php wp_nonce_field('woocommerce-process_checkout', 'woocommerce-process-checkout-nonce'); ?>
	</div>
</div>
<?php
if (!wp_doing_ajax()) {
	do_action('woocommerce_review_order_after_payment');
}
