<?php

namespace OrderDetect\Frontend;

class Form {

    public static function otp_form() {
?>
        <div class="otp-verification-container" id="od-order-verification-popup">
            <div class="otp-verification-inner" id="od-order-verification-second-step">
                <div class="otp-verification-header">
                    <h2><?php echo __('Order Verification', 'order-detect'); ?></h2>
                    <label class="modal__close" for="modal-1"></label>
                </div>
                <div class="otp-verification-body">
                    <div class="otp-processing-area">
                        <div class="order-detect-loader"></div>
                    </div>
                    <div class="otp-form-area">
                        <p class="otp-sedning-msg" id="otp-sedning-msg"></p>
                        <p class="otp-status-success" id="otp-status-notice"></p>
                        <p class="otp-status-error" id="otp-verify-failed"></p>
                        <form class="otp-verification-form">
                            <div class="otp-form-group otp-form-group-25">
                                <input type="number" name="otp-code" class="otp-code" id="otp-code" maxlength="4" placeholder="<?php echo __('Enter OTP Code', 'order-detect'); ?>">
                            </div>
                            <div class="otp-form-group">
                                <button type="button" class="otp-verification-btn" id="otp-verify-btn">
                                    <?php echo __('Verify', 'order-detect'); ?>
                                </button>
                            </div>
                            <div class="otp-form-group" id="otp-resend-section"></div>
                        </form>
                        <div id="otp-process-loader" class="otp-process-loader"></div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }

    public static function block_info_popup() {
        ?>
        <div class="otp-verification-container od-block-info-popup" id="od-block-info-popup">
            <div class="otp-verification-inner od-block-info-popup-inner" id="od-block-info-popup-inner">
                <div class="otp-verification-header od-block-info-popup-header">
                    <h2 class="od-block-info-popup-title"></h2>
                    <label class="od-block-info-popup-close" for="od-block-info-popup-close"></label>
                </div>
                <div class="otp-verification-body od-block-info-popup-body">

                </div>
            </div>
        </div>
    <?php
    }
}
