<div id="order-detect-order_notifications" class="order-detect-settings-tab">
    <div id="order-detect-settings-order_notifications" class="order-detect-settings-section order-detect-order_notifications">
        <h2>Turn SMS alerts on/off by order status:</h2>
        <table>
            <tbody>
                <?php
                $order_statuses = wc_get_order_statuses();
                foreach ($order_statuses as $status_key => $status_label) {
                    $sanitized_key = sanitize_title($status_key);
                    ?>
                    <tr data-id="<?php echo esc_attr($sanitized_key); ?>" id="order-detect-meta-<?php echo esc_attr($sanitized_key); ?>" class="order-detect-field order-detect-meta-checkbox type-checkbox">
                        <th class="order-detect-label">
                            <label for="<?php echo esc_attr($sanitized_key); ?>">
                                <?php echo esc_html($status_label); ?>
                            </label>
                        </th>
                        <td class="order-detect-control">
                            <div class="order-detect-control-wrapper">
                                <label class="order-detect-switch">
                                    <input class="order-detect-settings-field order-detect-status-checkbox order-detect-status-alert" 
                                        id="<?php echo esc_attr($sanitized_key); ?>" 
                                        type="checkbox" 
                                        name="<?php echo esc_attr($sanitized_key); ?>_enable" 
                                        value="1" 
                                        <?php checked( isset($setting_options[ $sanitized_key . '_enable' ]) ? $setting_options[$sanitized_key . '_enable']: 0, 1 ); ?>>
                                    <div class="slider"></div>
                                </label>
                            </div>
                        </td>
                    </tr>
                    <tr data-id="<?php echo esc_attr($sanitized_key); ?>_message" id="order-detect-meta-<?php echo esc_attr($sanitized_key); ?>_message" class="order-detect-field order-detect-meta-textarea order-detect-status-textarea type-textarea">
                        <th class="order-detect-label">
                            <label for="<?php echo esc_attr($sanitized_key); ?>_message">
                                Message                                                            
                            </label>
                        </th>
                        <td class="order-detect-control">
                            <div class="order-detect-control-wrapper">
                                <?php $message = esc_textarea(isset($setting_options[$sanitized_key . '_message']) ? $setting_options[$sanitized_key . '_message'] : ''); ?>
                                <textarea class="order-detect-settings-field order-detect-status-alert" id="<?php echo esc_attr($sanitized_key); ?>_message" name="<?php echo esc_attr($sanitized_key); ?>_message" placeholder="<?php echo esc_attr($status_label); ?> Message" rows="3" cols="3" wrap="hard"><?php echo $message; ?></textarea>
                                <p class="order-detect-field-help">
                                    Placeholder text: 
                                                    Store Name: <span class="od-dynamic-variable">%store_name%</span>, 
                                                    Name: <span class="od-dynamic-variable">%billing_first_name%</span>,
                                                    State: <span class="od-dynamic-variable">%billing_state%</span>, 
                                                    City: <span class="od-dynamic-variable">%billing_city%</span>, 
                                                    Address: <span class="od-dynamic-variable">%billing_address_1%</span>,
                                                    Order Id: <span class="od-dynamic-variable">%order_id%</span>, 
                                                    Order Status: <span class="od-dynamic-variable">%status%</span>, 
                                                    Order Date: <span class="od-dynamic-variable">%order_date_created%</span>, 
                                                    Order Currency: <span class="od-dynamic-variable">%order_currency%</span>, 
                                                    Items: <span class="od-dynamic-variable">%od_items%</span>, 
                                                    Shipping: <span class="od-dynamic-variable">%od_shipping%</span>, 
                                                    Total Price: <span class="od-dynamic-variable">%total_price%</span>,  
                                                    Payment Method: <span class="od-dynamic-variable">%payment_method%</span>
                                    .
                                </p>
                            </div>
                        </td>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
        <p class="submit">
            <button type="button" name="order-alerts-save-btn" id="order-alerts-save-btn" class="btn-settings order-detect-settings-button">
                <span class="dashicons dashicons-cloud-saved"></span> Save
            </button>
        </p>
    </div>
    </div>