<?php

    $license_options = wp_parse_args(get_option('orderdetect_license'));
    $license_key = array_key_exists('key', $license_options) ? $license_options['key'] : '';
    $license_expires = array_key_exists('expires', $license_options) ? $license_options['expires'] : '';

    $setting_options = wp_parse_args(get_option($this->_optionName), $this->_defaultOptions);
    $sms_provider = $setting_options['sms_provider'] ? $setting_options['sms_provider'] : '';
    $sms_api_key = $setting_options['sms_api_key'] ? $setting_options['sms_api_key'] : array(
        'greenweb' => '',
        'alpha' => '',
        'dianahost' => '',
        'mimsms' => '',
        'bulksmsbd' => ''
    );
    $enable_otp = $setting_options['enable_otp'] ? $setting_options['enable_otp'] : '0';
    $checkout_otp_message = $setting_options['checkout_otp_message'] ? $setting_options['checkout_otp_message'] : '';
    
    $delivery_partner = $setting_options['delivery_partner'] ? $setting_options['delivery_partner'] : '';
    $enable_invoice = $setting_options['enable_invoice'] ? $setting_options['enable_invoice'] : '0';
    $enable_packing_slip = $setting_options['enable_packing_slip'] ? $setting_options['enable_packing_slip'] : '0';
    $business_name = $setting_options['business_name'] ? $setting_options['business_name'] : get_bloginfo('name');
    $invoice_packing_slip_logo = $setting_options['invoice_packing_slip_logo'] ? $setting_options['invoice_packing_slip_logo'] : ORDERDETECT_ASSETS."/img/160x160.svg";
    $enable_footer_text = $setting_options['enable_footer_text'] ? $setting_options['enable_footer_text'] : '0';
    $footer_text_heading = $setting_options['footer_text_heading'] ? $setting_options['footer_text_heading'] : '';
    $footer_text_details = $setting_options['footer_text_details'] ? $setting_options['footer_text_details'] : '';
    $primary_color = $setting_options['primary_color'] ? $setting_options['primary_color'] : '';

    $balance = wp_parse_args( get_option('orderdetect_sms_balance', ['greenweb' => 0.00, 'alpha' => 0.00, 'dianahost' => 0.00, 'mimsms' => 0.00, 'bulksmsbd' => 0.00]));
?>
<div class="order-detect-settings-wrap">
    <div class="order-detect-settings-header">
        <div class="order-detect-header-full">
            <img src="<?php echo ORDERDETECT_ASSETS ?>/img/order-detect-logo.png" alt="Order Detect">
            <h2 class="title"><?php _e('Order Detect', 'order-detect'); ?></h2>
        </div>
    </div>

    <div class="order-detect-left-right-settings">
        <div class="order-detect-settings">

            <?php include_once 'settings/navbar.php'; ?>

            <div class="order-detect-settings-content">
                <div class="order-detect-settings-form-wrapper">
                    <?php include_once 'settings/license.php'; ?>
                    <?php include_once 'settings/sms-provider.php'; ?>
                    <?php include_once 'settings/checkout-otp.php'; ?>
                    <?php include_once 'settings/order-notifications.php'; ?>
                </div>
            </div>
            <?php include_once 'settings/footer.php'; ?>
        </div>
    </div>
</div>
<script>
    function toggleVisibility(id) {
        const inputField = document.getElementById(id);
        const icon = document.getElementById('toggle-icon');

        if (inputField.type === 'password') {
            inputField.type = 'text';
            icon.classList.remove('dashicons-hidden');
            icon.classList.add('dashicons-visibility');
        } else {
            inputField.type = 'password';
            icon.classList.remove('dashicons-visibility');
            icon.classList.add('dashicons-hidden');
        }
    }
    toggleVisibility('sms_api_key');
    toggleVisibility('dianahost_sender_id');
    toggleVisibility('mimsms_sender_id');
    toggleVisibility('mimsms_username');
    toggleVisibility('bulksmsbd_sender_id');
</script>