<?php
    if (! $helper->check_license(wp_parse_args(get_option('orderdetect_license')))) {
        return;
    }
    // সেভ অপশন
    if ( isset( $_POST['save_blocked_data'] ) ) {
        $blocked_ips = isset( $_POST['blocked_ips'] ) ? explode( "\n", sanitize_textarea_field( $_POST['blocked_ips'] ) ) : [];
        $blocked_phones = isset( $_POST['blocked_phones'] ) ? explode( "\n", sanitize_textarea_field( $_POST['blocked_phones'] ) ) : [];

        update_option( 'blocked_ips', array_map( 'trim', $blocked_ips ) );
        update_option( 'blocked_phones', array_map( 'trim', $blocked_phones ) );
        echo '<div class="updated"><p>Settings saved.</p></div>';
    }

    // অপশন পেজের ফর্ম
    $blocked_ips = get_option( 'blocked_ips', [] );
    $blocked_phones = get_option( 'blocked_phones', [] );
    ?>
    <style>
        .notice-warning, .e-notice.notice, .updated { display: none; }
    </style>
	<div class="order-detect-settings-wrap">
        <div class="order-detect-settings-header">
            <div class="order-detect-header-full">
                <img src="<?php echo ORDERDETECT_ASSETS ?>/img/order-detect-logo.png" alt="Order Detect">
                <h2>Fraud Blocker</h2>
            </div>
        </div>
    
        <div class="order-detect-left-right-settings">
            <div class="order-detect-settings">
                <div class="order-detect-settings-content">
                    <div class="order-detect-settings-form-wrapper">
                        <div class="order-detect-settings-tab active">
                        <div class="order-detect-settings-section">
                            <form method="post">
                                <table class="form-table">
                                    <tr class="order-detect-field">
                                        <th class="order-detect-label"><label>Blocked IPs</label></th>
                                        <td class="order-detect-control">
                                            <textarea class="widefat" name="blocked_ips" rows="5"><?php echo implode( "\n", $blocked_ips ); ?></textarea>
                                        </td>
                                    </tr>
                                    <tr class="order-detect-field">
                                        <th class="order-detect-label"><label>Blocked Phone Numbers</label></th>
                                        <td class="order-detect-control">
                                            <textarea class="widefat" name="blocked_phones" rows="5"><?php echo implode( "\n", $blocked_phones ); ?></textarea>
                                        </td>
                                    </tr>
                                </table>
                                <input type="submit" name="save_blocked_data" class="button btn-settings order-detect-settings-button " value="Save Changes">
                            </form>
                        </div>
                        </div>
                    </div>
                </div>
                <?php include_once 'settings/footer.php'; ?>
            </div>
        </div>
    </div>