<style>
    .notice-warning, .e-notice.notice { display: none; }
    .od-tab-content { display: block !important; margin-top: 0px; padding-top: 0px;  }
    .od-toggle-switch { position: relative; display: inline-block; width: 60px; height: 34px; }
    .od-toggle-switch input { opacity: 0; width: 0; height: 0; }
    .od-toggle-slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px; }
    .od-toggle-slider:before { position: absolute; content: ""; height: 26px; width: 26px; left: 4px; bottom: 4px; background-color: white; transition: .4s; border-radius: 50%; }
    input:checked + .od-toggle-slider { background-color: #45AAD5; }
    input:checked + .od-toggle-slider:before { transform: translateX(26px); }
    input[type=number], input[type=text], textarea { border: 1px solid #ddd; border-radius: 4px; padding: 8px; width: 100%; max-width: 400px; }
    input[type=number]:focus, input[type=text]:focus, textarea:focus { border-color: #45AAD5; box-shadow: 0 0 0 1px #45AAD5; }
    #submit { 
        background-color: #45AAD5;
        color: #fff;
        letter-spacing: 1px;
        font-weight: 600;
        text-transform: uppercase;
        cursor: pointer;
        box-shadow: rgba(0, 0, 0, 0.1) 0 2px 4px;
        border: none;
        border-image: initial;
        padding: 13px 25px;
        border-radius: 6px;
        margin-left: 20px;
        transition: 0.3s; 
    }
    .order-detect-field-help { color: #666; margin-top: 10px; font-size: 13px; }
    .od-dynamic-variable { background: #f5f5f5; padding: 2px 5px; border-radius: 3px; font-family: monospace; }
    .form-table td p{font-size: 13px; margin-top: 5px;}
</style>

<div class="order-detect-settings-wrap">
    <div class="order-detect-settings-header">
        <div class="order-detect-header-full">
            <img src="<?php echo ORDERDETECT_ASSETS ?>/img/order-detect-logo.png" alt="Order Detect">
            <h2>Set Block Timer</h2>
        </div>
    </div>
    
    <div class="order-detect-left-right-settings">
        <div class="order-detect-settings">
            <div class="order-detect-settings-menu">
                <ul>
                    <li class="order-detect-tab-nav-item" data-tab="phone">
                        <span>
                            Phone Number
                        </span>
                    </li>

                    <li class="order-detect-tab-nav-item" data-tab="device">
                        <span>Device ID</span>
                    </li>

                    <li class="order-detect-tab-nav-item" data-tab="ip">
                        <span>IP Address </span>
                    </li>           
                </ul>
            </div>

            <div class="order-detect-settings-content">
                <div class="order-detect-settings-form-wrapper">
                    <form method="post" action="options.php">
                        <?php settings_fields('order-limit-blocker-settings'); ?>
                        <input type="hidden" name="od_blocker_active_tab" id="od_blocker_active_tab" value="<?php echo get_option('od_blocker_active_tab', 'phone'); ?>">
                        <script>
                            jQuery(document).ready(function($) {
                                var activeTab = $('#od_blocker_active_tab').val();
                                $('.order-detect-settings-menu li[data-tab="' + activeTab + '"]').addClass('active').siblings().removeClass('active');
                                $('#order-detect-' + activeTab).addClass('active').siblings().removeClass('active');
                                
                                $('.order-detect-settings-menu li').on('click', function() {
                                    var tab = $(this).data('tab');
                                    $('#od_blocker_active_tab').val(tab);
                                    $(this).addClass('active').siblings().removeClass('active');
                                    $('#order-detect-' + tab).addClass('active').siblings().removeClass('active');
                                });
                            });
                        </script>

                        <!-- Phone Number Tab -->
                        <div id="order-detect-phone" class="order-detect-settings-tab active">
                            <table class="form-table">
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Phone Number</label></th>
                                    <td>
                                        <label class="od-toggle-switch">
                                            <input type="checkbox" name="od_phone_block_enabled" value="1" <?php checked(get_option('od_phone_block_enabled'), 1); ?>>
                                            <span class="od-toggle-slider"></span>
                                        </label>
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Maximum Orders</label></th>
                                    <td>
                                        <input class="widefat" type="number" name="od_phone_max_orders" value="<?php echo esc_attr(get_option('od_phone_max_orders', 5)); ?>" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Duration (minutes)</label></th>
                                    <td>
                                        <input class="widefat" type="number" name="od_phone_block_duration" value="<?php echo esc_attr(get_option('od_phone_block_duration', 60)); ?>" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Messege Title</label></th>
                                    <td>
                                        <input class="widefat" type="text" name="od_phone_block_message_title" value="<?php echo esc_attr(get_option('od_phone_block_message_title', 'আন্তরিকভাবে দুঃখিত')); ?>" placeholder="Enter Block Message Title" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Message</label></th>
                                    <td>
                                        <textarea class="widefat" name="od_phone_block_message" rows="4" cols="20"><?php echo esc_attr(get_option('od_phone_block_message', 'আপনি %order_date% %order_time% সময়ে অর্ডার করেছেন। এই মুহূর্তে আপনার অর্ডারটি %order_status% অবস্থায় রয়েছে। আপনার অর্ডার নম্বর %order_number%। অনুগ্রহ করে %block_duration% ঘন্টা পর আবার চেষ্টা করুন। যেকোনো সমস্যায় যোগাযোগ করুন।')); ?></textarea>
                                        <p class="order-detect-field-help">
                                            Placeholder text:
                                            Name: <span class="od-dynamic-variable">%billing_first_name%</span>,
                                            State: <span class="od-dynamic-variable">%billing_state%</span>, 
                                            City: <span class="od-dynamic-variable">%billing_city%</span>, 
                                            Address: <span class="od-dynamic-variable">%billing_address_1%</span>,
                                            Order Id: <span class="od-dynamic-variable">%order_number%</span>, 
                                            Order Status: <span class="od-dynamic-variable">%order_status%</span>, 
                                            Order Date: <span class="od-dynamic-variable">%order_date%</span>, 
                                            Order Time: <span class="od-dynamic-variable">%order_time%</span>, 
                                            Order Currency: <span class="od-dynamic-variable">%order_currency%</span>, 
                                            Order Total: <span class="od-dynamic-variable">%order_total%</span>,
                                            Payment Method: <span class="od-dynamic-variable">%payment_method%</span>,
                                            Maximum Order: <span class="od-dynamic-variable">%max_orders%</span>,
                                            Total Order: <span class="od-dynamic-variable">%order_count%</span>,
                                            Block Duration: <span class="od-dynamic-variable">%block_duration%</span>
                                            .
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <!-- Device ID Tab -->
                        <div id="order-detect-device" class="order-detect-settings-tab">
                            <table class="form-table">
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Device ID</label></th>
                                    <td>
                                        <label class="od-toggle-switch">
                                            <input type="checkbox" name="od_device_block_enabled" value="1" <?php checked(get_option('od_device_block_enabled'), 1); ?>>
                                            <span class="od-toggle-slider"></span>
                                        </label>
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Maximum Orders</label></th>
                                    <td>
                                        <input class="widefat" type="number" name="od_device_max_orders" value="<?php echo esc_attr(get_option('od_device_max_orders', 5)); ?>" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Duration (minutes)</label></th>
                                    <td>
                                        <input class="widefat" type="number" name="od_device_block_duration" value="<?php echo esc_attr(get_option('od_device_block_duration', 60)); ?>" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Messege Title</label></th>
                                    <td>
                                        <input class="widefat" type="text" name="od_device_block_message_title" value="<?php echo esc_attr(get_option('od_device_block_message_title', 'আন্তরিকভাবে দুঃখিত')); ?>" placeholder="Enter Block Message Title" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Message</label></th>
                                    <td>
                                        <textarea class="widefat" name="od_device_block_message" rows="4" cols="20"><?php echo esc_attr(get_option('od_device_block_message', 'আপনি %order_date% %order_time% সময়ে অর্ডার করেছেন। এই মুহূর্তে আপনার অর্ডারটি %order_status% অবস্থায় রয়েছে। আপনার অর্ডার নম্বর %order_number%। অনুগ্রহ করে %block_duration% ঘন্টা পর আবার চেষ্টা করুন। যেকোনো সমস্যায় যোগাযোগ করুন।')); ?></textarea>
                                        <p class="order-detect-field-help">
                                            Placeholder text:
                                            Name: <span class="od-dynamic-variable">%billing_first_name%</span>,
                                            State: <span class="od-dynamic-variable">%billing_state%</span>, 
                                            City: <span class="od-dynamic-variable">%billing_city%</span>, 
                                            Address: <span class="od-dynamic-variable">%billing_address_1%</span>,
                                            Order Id: <span class="od-dynamic-variable">%order_number%</span>, 
                                            Order Status: <span class="od-dynamic-variable">%order_status%</span>, 
                                            Order Date: <span class="od-dynamic-variable">%order_date%</span>, 
                                            Order Time: <span class="od-dynamic-variable">%order_time%</span>, 
                                            Order Currency: <span class="od-dynamic-variable">%order_currency%</span>, 
                                            Order Total: <span class="od-dynamic-variable">%order_total%</span>,
                                            Payment Method: <span class="od-dynamic-variable">%payment_method%</span>,
                                            Maximum Order: <span class="od-dynamic-variable">%max_orders%</span>,
                                            Total Order: <span class="od-dynamic-variable">%order_count%</span>,
                                            Block Duration: <span class="od-dynamic-variable">%block_duration%</span>
                                            .
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <!-- IP Address Tab -->
                        <div id="order-detect-ip" class="order-detect-settings-tab">
                            <table class="form-table">
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>IP Address</label></th>
                                    <td>
                                        <label class="od-toggle-switch">
                                            <input type="checkbox" name="od_ip_block_enabled" value="1" <?php checked(get_option('od_ip_block_enabled'), 1); ?>>
                                            <span class="od-toggle-slider"></span>
                                        </label>
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Maximum Orders</label></th>
                                    <td>
                                        <input class="widefat" type="number" name="od_ip_max_orders" value="<?php echo esc_attr(get_option('od_ip_max_orders', 5)); ?>" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Duration (minutes)</label></th>
                                    <td>
                                        <input class="widefat" type="number" name="od_ip_block_duration" value="<?php echo esc_attr(get_option('od_ip_block_duration', 60)); ?>" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Messege Title</label></th>
                                    <td>
                                        <input class="widefat" type="text" name="od_ip_block_message_title" value="<?php echo esc_attr(get_option('od_ip_block_message_title', 'আন্তরিকভাবে দুঃখিত')); ?>" placeholder="Enter Block Message Title" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Block Message</label></th>
                                    <td>
                                        <textarea class="widefat" name="od_ip_block_message" rows="4" cols="20"><?php echo esc_attr(get_option('od_ip_block_message', 'আপনি %order_date% %order_time% সময়ে অর্ডার করেছেন। এই মুহূর্তে আপনার অর্ডারটি %order_status% অবস্থায় রয়েছে। আপনার অর্ডার নম্বর %order_number%। অনুগ্রহ করে %block_duration% ঘন্টা পর আবার চেষ্টা করুন। যেকোনো সমস্যায় যোগাযোগ করুন।')); ?></textarea>
                                        <p class="order-detect-field-help">
                                            Placeholder text:
                                            Name: <span class="od-dynamic-variable">%billing_first_name%</span>,
                                            State: <span class="od-dynamic-variable">%billing_state%</span>, 
                                            City: <span class="od-dynamic-variable">%billing_city%</span>, 
                                            Address: <span class="od-dynamic-variable">%billing_address_1%</span>,
                                            Order Id: <span class="od-dynamic-variable">%order_number%</span>, 
                                            Order Status: <span class="od-dynamic-variable">%order_status%</span>, 
                                            Order Date: <span class="od-dynamic-variable">%order_date%</span>, 
                                            Order Time: <span class="od-dynamic-variable">%order_time%</span>, 
                                            Order Currency: <span class="od-dynamic-variable">%order_currency%</span>, 
                                            Order Total: <span class="od-dynamic-variable">%order_total%</span>,
                                            Payment Method: <span class="od-dynamic-variable">%payment_method%</span>,
                                            Maximum Order: <span class="od-dynamic-variable">%max_orders%</span>,
                                            Total Order: <span class="od-dynamic-variable">%order_count%</span>,
                                            Block Duration: <span class="od-dynamic-variable">%block_duration%</span>
                                            .
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="od-tab-content order-detect-settings-tab" style="">
                            <table class="form-table">
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Phone Number</label></th>
                                    <td>
                                        <input class="widefat" type="text" name="od_phone_number" value="<?php echo esc_attr(get_option('od_phone_number')); ?>" placeholder="Enter Phone Number" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>WhatsApp Link</label></th>
                                    <td>
                                        <input class="widefat" type="text" name="od_whatsapp_link" value="<?php echo esc_attr(get_option('od_whatsapp_link')); ?>" placeholder="Enter WhatsApp link" />
                                    </td>
                                </tr>
                                <tr class="order-detect-field">
                                    <th class="order-detect-label"><label>Messenger Link</label></th>
                                    <td>
                                        <input class="widefat" type="text" name="od_messenger_link" value="<?php echo esc_attr(get_option('od_messenger_link')); ?>" placeholder="Enter Messenger link" />
                                    </td>
                                </tr>
                                
                            </table>
                        </div>
                        <?php submit_button(null, 'primary btn-settings order-detect-settings-button od-submit-button'); ?>
                    </form>
                </div>
            </div>
            <?php include_once 'settings/footer.php'; ?>
        </div>
    </div>
</div>
