<?php
namespace OrderDetect\Admin;

if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/template.php';
    require_once ABSPATH . 'wp-admin/includes/class-wp-screen.php';
    require_once ABSPATH . 'wp-admin/includes/screen.php';
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

// Include the list table classes
require_once plugin_dir_path(__FILE__) . '../BlockedPhoneList.php';
require_once plugin_dir_path(__FILE__) . '../BlockedDeviceList.php';
require_once plugin_dir_path(__FILE__) . '../BlockedIPList.php';

// Initialize list tables
$phone_list = new BlockedPhoneList();
$device_list = new BlockedDeviceList();
$ip_list = new BlockedIPList();

// Get current tab and view
$current_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'phone';
$current_view = isset($_GET['view']) ? sanitize_text_field($_GET['view']) : '';
$identifier_type = isset($_GET['identifier_type']) ? sanitize_text_field($_GET['identifier_type']) : '';
$identifier_value = isset($_GET['identifier_value']) ? sanitize_text_field($_GET['identifier_value']) : '';

// Prepare items for the current tab
switch ($current_tab) {
    case 'device':
        $device_list->prepare_items();
        break;
    case 'ip':
        $ip_list->prepare_items();
        break;
    default:
        $phone_list->prepare_items();
        break;
}
?>

<div class="order-detect-settings-wrap order-detect-blocked-devices-management">
    <div class="order-detect-settings-header">
        <div class="order-detect-header-full">
            <img src="<?php echo ORDERDETECT_ASSETS ?>/img/order-detect-logo.png" alt="Order Detect">
            <h2 class="title"><?php _e('Blocked Devices Management', 'order-detect'); ?></h2>
        </div>
    </div>

    <nav class="nav-tab-wrapper">
        <?php
        $active_tab = !empty($identifier_type) ? $identifier_type : $current_tab;
        ?>
        <a href="?page=block-list&tab=phone" class="nav-tab <?php echo $active_tab === 'phone' ? 'nav-tab-active' : ''; ?>">
            Phone Numbers
        </a>
        <a href="?page=block-list&tab=device" class="nav-tab <?php echo $active_tab === 'device' ? 'nav-tab-active' : ''; ?>">
            Device IDs
        </a>
        <a href="?page=block-list&tab=ip" class="nav-tab <?php echo $active_tab === 'ip' ? 'nav-tab-active' : ''; ?>">
            IP Addresses
        </a>
    </nav>

    <div class="tab-content">
        <?php if (empty($identifier_type)): ?>
        <form method="get">
            <input type="hidden" name="page" value="block-list" />
            <input type="hidden" name="tab" value="<?php echo esc_attr($current_tab); ?>" />
        <?php
            switch ($current_tab) {
                case 'device':
                    $device_list->search_box('Search Device IDs', 'device_search');
                    break;
                case 'ip':
                    $ip_list->search_box('Search IP Addresses', 'ip_search');
                    break;
                default:
                    $phone_list->search_box('Search Phone Numbers', 'phone_search');
                    break;
            }
        ?>
        </form>
        <?php endif; ?>

        <?php

        if (!empty($current_view) && !empty($identifier_type) && !empty($identifier_value)) {
            // Include and display the identifier relations view
            require_once plugin_dir_path(__FILE__) . 'identifier-relations.php';
        } else {
            switch ($current_tab) {
                case 'device':
                    $device_list->display();
                    break;
                case 'ip':
                    $ip_list->display();
                    break;
                default:
                    $phone_list->display();
                    break;
            }
        }
        ?>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Handle delete action
    $('.delete-action').on('click', function(e) {
        e.preventDefault();
        if (!confirm('Are you sure you want to delete this item?')) {
            return;
        }
        var $button = $(this);
        var data = {
            action: 'delete_block',
            identifier: $button.data('identifier'),
            block_type: $button.data('type'),
            _wpnonce: $button.data('nonce')
        };

        $.post(ajaxurl, data, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error deleting item');
            }
        });
    });
    
    var blockingTimeDropdown = $('<select>', {
        class: 'bulk-blocking-time',
        name: 'bulk_blocking_time'
    }).append($('<option>', {
        value: '',
        text: 'Select Blocking Time'
    }));

    // Add blocking time options
    var durations = {
        '1 hour': '1 hour',
        '5 hour': '5 hours',
        '10 hour': '10 hours',
        '15 hour': '15 hours',
        '20 hour': '20 hours',
        '1 day': '1 day',
        '2 day': '2 days',
        '3 day': '3 days',
        '5 day': '5 days',
        '1 week': '1 week',
        '2 week': '2 weeks',
        '1 month': '1 month',
        '2 month': '2 months',
        '3 month': '3 months',
        '6 month': '6 months',
        '1 year': '1 year',
        '5 year': '5 years'
    };

    Object.entries(durations).forEach(function([value, label]) {
        blockingTimeDropdown.append($('<option>', {
            value: value,
            text: label
        }));
    });

    // Only show bulk actions if not viewing identifier relations
    var urlParams = new URLSearchParams(window.location.search);
    if (!urlParams.has('identifier_type')) {
        $('.bulkactions').append(blockingTimeDropdown);
    } else {
        $('.bulkactions').hide();
    }

    $('.button.action').on('click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var bulkAction = $(this).prev('select').val();
        var blockingTime = $('.bulk-blocking-time').val();
        var $checkedBoxes = $('.wp-list-table').find('input[type="checkbox"][name="bulk-action[]"]:checked');
    
        if (!bulkAction) {
            alert('Please select an action');
            return;
        }
    
        if (bulkAction === 'block' && !blockingTime) {
            alert('Please select blocking time');
            return;
        }
    
        if ((bulkAction === 'block' || bulkAction === 'unblock') && $checkedBoxes.length > 0) {
            
            var identifiers = [];
            var block_types = [];
            var block_untils = [];

            var block_until = '';
        
            if (blockingTime) {
                var now = new Date();
                var parts = blockingTime.match(/^(\d+)\s+(hour|day|week|month|year)s?$/);
                if (parts) {
                    var amount = parseInt(parts[1]);
                    var unit = parts[2];
                    
                    switch(unit) {
                        case 'hour':
                            now.setHours(now.getHours() + amount);
                            break;
                        case 'day':
                            now.setDate(now.getDate() + amount);
                            break;
                        case 'week':
                            now.setDate(now.getDate() + (amount * 7));
                            break;
                        case 'month':
                            now.setMonth(now.getMonth() + amount);
                            break;
                        case 'year':
                            now.setFullYear(now.getFullYear() + amount);
                            break;
                    }
                    block_until = now.toISOString().slice(0, 19).replace('T', ' ');
                }
            }
    
            $checkedBoxes.each(function() {
                var $row = $(this).closest('tr');
                var $blockButton = $row.find('.block-action');
                identifiers.push($blockButton.data('identifier'));
                block_types.push($blockButton.data('type'));
                block_untils.push(bulkAction === 'block' ? block_until : '');
            });
    
            $button.prop('disabled', true);
    
            $.ajax({
                url: order_detect.ajax_url,
                method: 'POST',
                data: {
                    action: 'handle_bulk_block_status',
                    identifiers: identifiers,
                    block_types: block_types,
                    block_untils: block_untils
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert('Error updating block status');
                    }
                },
                error: function() {
                    alert('Error processing bulk action');
                },
                complete: function() {
                    $button.prop('disabled', false);
                }
            });
        }
    });

    $('<style>').text(`.button.dashicons {
    width: 30px;
    height: 30px;
    padding: 0;
    line-height: 28px;
    text-align: center;
    vertical-align: middle;
}
.button.dashicons:before {
    margin: 0;
    padding: 0;
    font-size: 18px;
    line-height: 28px;
    width: 100%;
    height: 100%;
}
.bulk-blocking-time {
        margin: 0 4px;
        vertical-align: middle;
    }`).appendTo('head');

    // Handle block/unblock actions
    $('.block-action').on('click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var $row = $button.closest('tr');
        var $durationPicker = $row.find('.block-duration-picker');
        
        var duration = $durationPicker.val();
        var block_until = '';
        
        if (duration) {
            var now = new Date();
            var parts = duration.match(/^(\d+)\s+(hour|day|week|month|year)s?$/);
            if (parts) {
                var amount = parseInt(parts[1]);
                var unit = parts[2];
                
                switch(unit) {
                    case 'hour':
                        now.setHours(now.getHours() + amount);
                        break;
                    case 'day':
                        now.setDate(now.getDate() + amount);
                        break;
                    case 'week':
                        now.setDate(now.getDate() + (amount * 7));
                        break;
                    case 'month':
                        now.setMonth(now.getMonth() + amount);
                        break;
                    case 'year':
                        now.setFullYear(now.getFullYear() + amount);
                        break;
                }
                block_until = now.toISOString().slice(0, 19).replace('T', ' ');
            }
        }

        var data = {
            action: 'update_block_status',
            identifier: $button.data('identifier'),
            block_type: $button.data('type'),
            block_until: block_until,
            _wpnonce: $button.data('nonce')
        };

        $.post(ajaxurl, data, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error updating block status');
            }
        });
    });

    $('.button.action').on('click', function(e) {

        e.preventDefault();
        var $button = $(this);
        var bulkAction = $(this).prev('select').val();
        var $checkedBoxes = $('.wp-list-table').find('input[type="checkbox"][name="bulk-action[]"]:checked');
    
        if (!bulkAction) {
            alert('Please select an action');
            return;
        }
    
        if ((bulkAction === 'delete') && $checkedBoxes.length > 0) {
            if (bulkAction === 'delete' && !confirm('Are you sure you want to delete these items?')) {
                return;
            }
            
            var identifiers = [];
            var block_types = [];
    
            $checkedBoxes.each(function() {
                var $row = $(this).closest('tr');
                var $blockButton = $row.find('.block-action');
                identifiers.push($blockButton.data('identifier'));
                block_types.push($blockButton.data('type'));
            });
    
            $button.prop('disabled', true);
    
            $.ajax({
                url: order_detect.ajax_url,
                method: 'POST',
                data: {
                    action: 'bulk_block_delete',
                    identifiers: identifiers,
                    block_types: block_types
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert('Error updating block status');
                    }
                },
                error: function() {
                    alert('Error processing bulk action');
                },
                complete: function() {
                    $button.prop('disabled', false);
                }
            });
        }

    });
});
</script>