<?php

namespace OrderDetect\Admin;

use OrderDetect\Admin\OTPLogList;
use OrderDetect\Helper;

class SMSLog {

    public $main;

    public function __construct($main) {
        $this->main = $main;
        add_filter( 'orderdetect_admin_menu', array( $this, 'orderdetect_sms_log' ), PHP_INT_MAX );
        add_filter( 'set-screen-option', array( $this, 'set_screen_option' ), 10, 3 );
        add_action( "load-order-detect_page_sms-log", array( $this, 'add_screen_options' ) );
        add_action('admin_post_export_sms_logs', [$this, 'export_sms_logs']);

    }

    public function orderdetect_sms_log( $settings ) {
        if( ! Helper::check_license( wp_parse_args( get_option('orderdetect_license') ) ) ) {
            return;
        }
        
        $settings['sms-log']['parent_slug'] = 'order-detect';
        $settings['sms-log']['page_title'] = __( 'SMS Report', 'order-detect' );
        $settings['sms-log']['menu_title'] = __( 'SMS Report', 'order-detect' ); 
        $settings['sms-log']['capability'] = 'manage_woocommerce'; 
        $phone_number = isset( $_GET['s'] ) ? sanitize_text_field( $_GET['s'] ) : '';
        $sms_list_table = new SMSLogList( $phone_number );

        $settings['sms-log']['callback'] = function () use ($sms_list_table, $phone_number) {
            ?>
            <div class="order-detect-settings-wrap order-detect-blocked-devices-management" style="float:left;">
                <div class="order-detect-settings-header">
                    <div class="order-detect-header-full">
                        <img src="<?php echo ORDERDETECT_ASSETS ?>/img/order-detect-logo.png" alt="Order Detect">
                        <h2 class="title"><?php echo __('SMS Report', 'order-detect'); ?></h2>
                    </div>
                </div>
                <form method="get">
                    <input type="hidden" name="page" value="sms-log" />
                    <?php
                        $sms_list_table->prepare_items();
                        $sms_list_table->search_box(__('Search', 'order-detect'), 'phone');
                        $sms_list_table->views();
                        $sms_list_table->display();
                    ?>
                </form>
            </div>
            <?php
        };

        return $settings;
    }

    public function set_screen_option($status, $option, $value) {
        if (in_array($option, array('sms_log_per_page'), true)) {
            return $value;
        }

        return $status;
    }

    public function add_screen_options() {
        add_screen_option('per_page', array(
            'label'   => esc_html__('Number of items per page:', 'order-detect'),
            'default' => 20,
            'option'  => 'sms_log_per_page',
        ));
    }

    public function export_sms_logs() {
        if ( ! current_user_can('manage_woocommerce') ) {
            wp_die(__('You do not have sufficient permissions to access this page.', 'order-detect'));
        }
    
        global $wpdb;
    
        $status = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : 'all';
        $table_name = $wpdb->prefix . 'od_otp_log';
    
        $query = "SELECT id, phone_number, code, expires_at, is_verified, created_at FROM $table_name WHERE 1=1";
    
        if ($status === 'verified') {
            $query .= " AND is_verified = 1";
        } elseif ($status === 'unverified') {
            $query .= " AND is_verified = 0";
        }
    
        $sms_logs = $wpdb->get_results($query);
    
        // Set headers for Excel export
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="phone_number_logs_' . $status . '.xls"');
    
        // Output the data to Excel
        echo "ID\tPhone Number\tCode\tExpires At\tVerified?\tCreated At\n";
    
        foreach ($sms_logs as $log) {
            echo $log->id . "\t" . $log->phone_number . "\t" . $log->code . "\t" . $log->expires_at . "\t" . ($log->is_verified ? 'Yes' : 'No') . "\t" . $log->created_at . "\n";
        }
    
        exit; // Ensure no further output
    }
    
    
}
