<?php

namespace OrderDetect\Admin;

use OrderDetect\Helper;

class Menu {

    public $main;

    function __construct($main) {
        $this->main = $main;
        add_action( 'admin_menu', array( $this, 'admin_menu' ) );
    }

    public function admin_menu() {
        $parent_slug = 'order-detect';
        $capability = 'manage_woocommerce';
        $icon_url = ORDERDETECT_ASSETS.'/img/order-detect-icon.png';

        $settings   = apply_filters('orderdetect_admin_menu', array());

        $hook = add_menu_page(__('Order Detect', 'order-detect'), __('Order Detect', 'order-detect'), $capability, $parent_slug, [$this->main, 'plugin_page'], $icon_url, 50);
        add_action('admin_head-' . $hook, array($this, 'enqueue_assets'));

        if( !empty($settings) ){
            foreach ($settings as $slug => $setting) {
                $cap  = isset($setting['capability']) ? $setting['capability'] : 'delete_users';
                add_submenu_page($setting['parent_slug'], $setting['page_title'], $setting['menu_title'], $cap, $slug, $setting['callback']);
            }
        }
		
		if (! Helper::check_license(wp_parse_args(get_option('orderdetect_license')))) {
            return;
        }

        add_submenu_page(
            'order-detect',
            __('Courier Settings', 'order-detect'),
            __('Courier Settings', 'order-detect'),
            'manage_woocommerce',
            'courier-settings',
            array( $this, 'courier_settings_page' )
        );

        add_submenu_page(
            'order-detect',
            __('Fraud Blocker Settings', 'order-detect'),
            __('Fraud Blocker', 'order-detect'),
            'manage_woocommerce',
            'fraud-blocker',
            array( $this, 'fraud_blocker_settings_page' )

        );
		add_submenu_page(
            'order-detect',
            __('Set Block Timer', 'order-detect'),
            __('Set Block Timer', 'order-detect'),
            'manage_woocommerce',
            'order-limit-blocker',
            array( $this, 'order_limit_blocker_settings_page' )
        );
		add_submenu_page(
            'order-detect',
            __('Block List', 'order-detect'),
            __('Block List', 'order-detect'),
            'manage_woocommerce',
            'block-list',
            array( $this, 'blocked_devices_list_page' )
        );
    }

    public function enqueue_assets() {
        wp_enqueue_style('orderdetect-admin-boostrap');
        wp_enqueue_style('orderdetect-admin-style');
        wp_enqueue_script('orderdetect-admin-script');
    }

    public function order_limit_blocker_settings_page() {
        $template = __DIR__ . '/views/block-timer.php';
		if (file_exists($template)) {
			$helper = new Helper;
			include $template;
		}
    }

    public function blocked_devices_list_page() {

        $template = __DIR__ . '/views/block-list.php';
		if (file_exists($template)) {
			$helper = new Helper;
			include $template;
		}
    }

    public function fraud_blocker_settings_page() {
        $template = __DIR__ . '/views/fraud-blocker.php';
		if (file_exists($template)) {
			$helper = new Helper;
			include $template;
		}
    }

    public function courier_settings_page() {
        $template = __DIR__ . '/views/courier-settings.php';
		if (file_exists($template)) {
			$helper = new Helper;
			include $template;
		}
    }
}
