<?php
namespace OrderDetect\API;

use OrderDetect\Helper;
use WP_REST_Request;
use WP_REST_Response;

class LicenseAPI {

    public function __construct() {
        add_action('rest_api_init', array($this, 'register_routes'));
    }

    public function register_routes() {
        register_rest_route('orderdetect/v1', '/activate-license/', [
            'methods' => 'POST',
            'callback' => array($this, 'activate_license'),
            'permission_callback' => '__return_true',
        ]);
        register_rest_route('orderdetect/v1', '/deactivate-license/', [
            'methods' => 'POST',
            'callback' => array($this, 'deactivate_license'),
            'permission_callback' => '__return_true',
        ]);
        register_rest_route('orderdetect/v1', '/extend-license/', [
            'methods' => 'POST',
            'callback' => array($this, 'extend_license'),
            'permission_callback' => '__return_true',
        ]);
    }

    public function activate_license( WP_REST_Request $request ) {

        $license_key = $request->get_param('license_key');
        $license_expires = $request->get_param('license_expires');
        if( ! empty( $license_key ) && ! empty( $license_expires ) ) {
            $settings = [];
            $settings['key'] = Helper::encrypt_data($license_key, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV);
            $settings['expires'] = Helper::encrypt_data($license_expires, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV);
            update_option('orderdetect_license', $settings);
        }

        return new WP_REST_Response(['status' => 'success'], 200);
        
    }

    public function deactivate_license( WP_REST_Request $request ) {

        $license_key = $request->get_param('license_key');
        $setting_options = wp_parse_args(get_option('orderdetect_license'));
        $stored_license_key = array_key_exists('key', $setting_options) ? $setting_options['key'] : '';
        $stored_license_key = Helper::decrypt_data($stored_license_key, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV);

        if ($license_key === $stored_license_key) {
            delete_option('orderdetect_license');
            return new WP_REST_Response(['status' => 'success'], 200);
        } else {
            return new WP_REST_Response(['status' => 'failure', 'message' => 'License key does not match'], 400);
        }
    }

    public function extend_license( WP_REST_Request $request ) {

        $license_expire = $request->get_param('license_expire');
        if( ! empty( $license_expire ) ){
            $setting_options = wp_parse_args(get_option('orderdetect_license'));
            $stored_license_key = array_key_exists('key', $setting_options) ? $setting_options['key'] : '';
    
            $settings['key'] = $stored_license_key;
            $settings['expires'] = Helper::encrypt_data($license_expire, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV);
            update_option('orderdetect_license', $settings);
        }

        return new WP_REST_Response(['status' => 'success'], 200);
        
    }

}