<?php
namespace OrderDetect\Services;
use OrderDetect\Helper;

class OrderNotifications {
    protected static $_instance = null;

    public function __construct() {
        if( !Helper::check_license( wp_parse_args( get_option('orderdetect_license') ) ) ) return;
        add_action( 'woocommerce_order_status_changed', array( $this, 'send_sms_on_order_status_change' ), PHP_INT_MAX, 4);
        // add_action( 'add_meta_boxes', array( $this, 'order_status_notification_notes'), PHP_INT_MAX );
    }

    public function send_sms_on_order_status_change($order_id, $old_status, $new_status, $order) {
        $settings = wp_parse_args(get_option('orderdetect_settings', array(
            'sms_provider' => '',
            'sms_api_key' => array(
                'greenweb' => '',
                'alpha' => '',
                'dianahost' => '',
                'mimsms' => '',
                'bulksmsbd' => ''
            ),
            'mimsms_sender_id' => '',
            'mimsms_username' => '',
            'bulksmsbd_sender_id' => '',
            'enable_otp' => 0,
            'checkout_otp_message' => '',
            'dianahost_sender_id' => '',
            'enable_invoice' => 0,
            'enable_packing_slip' => 0,
            'invoice_packing_slip_logo' => '',
            'business_name' => '',
            'enable_footer_text' => 0,
            'footer_text_heading' => '',
            'footer_text_details' => '',
            'delivery_partner' => '',
            'primary_color' => '#000'
        )));

        if (isset($settings["wc-".$new_status."_enable"]) && $settings["wc-".$new_status."_enable"] == 1) {
            $billing_phone = $order->get_billing_phone();
            $message_template = isset($settings["wc-".$new_status."_message"]) ? $settings["wc-".$new_status."_message"] : 'Your order status has changed.';
            $order_items = [];
            foreach ($order->get_items() as $item_id => $item) {
                $order_items[] = $item->get_name();
            }
            
            $shipping_methods = $order->get_shipping_methods();
            $shipping_method_titles = [];
            foreach ($shipping_methods as $shipping_item) {
                $shipping_method_titles[] = $shipping_item->get_method_title();
            }

            $message = str_replace(
                array(
                    '%store_name%',
                    '%billing_first_name%',
                    '%billing_state%',
                    '%billing_city%',
                    '%billing_address_1%',
                    '%order_id%',
                    '%status%',
                    '%order_date_created%',
                    '%order_currency%',
                    '%total_price%',
                    '%payment_method%',
                    '%od_items%',
                    '%od_shipping%'
                ),
                array(
                    get_bloginfo('name'), // %store_name%
                    $order->get_billing_first_name(), // %billing_first_name%
                    $order->get_billing_state(), // %billing_state%
                    $order->get_billing_city(), // %billing_city%
                    $order->get_billing_address_1(), // %billing_address_1%
                    $order->get_id(), // %order_id%
                    wc_get_order_status_name($new_status), // %status%
                    $order->get_date_created()->date('Y-m-d H:i:s'), // %order_date_created%
                    $order->get_currency(), // %order_currency%
                    $order->get_total(), // %total_price%
                    $order->get_payment_method_title(), // %payment_method%
                    implode(', ', $order_items), // %od_items%
                    !empty($shipping_method_titles) ? implode(', ', $shipping_method_titles) : 'N/A' // %od_shipping%
                ),
                $message_template
            );
            
            // Send SMS notification
            od_send_alerts_based_on_order_status($billing_phone, $message);
            
            // Add order note about the notification
            $provider_name = ucfirst($settings['sms_provider']);
            $note = sprintf('%s: Notified customer about his order %s status', 'Order Detect', wc_get_order_status_name($new_status));
            $order_note_id = $order->add_order_note($note);
            
            // Add meta to identify this as an Order Detect notification note
            if ($order_note_id) {
                update_comment_meta($order_note_id, '_od_notification', '1');
            }
        }
    }

    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    public function order_status_notification_notes() {
        $screen_id = class_exists('Automattic\\WooCommerce\\Admin\\Features\\Features') ? 'woocommerce_page_wc-orders' : 'shop_order';
        add_meta_box(
            'od-order-status-notification-notes',
            __('Order Detect notes', 'order-detect'),
            array( $this, 'display_order_status_notes'),
            $screen_id,
            'side',
            'high'
        );
    }

    public function display_order_status_notes($post_or_order) {
        $order = $post_or_order instanceof \WC_Order ? $post_or_order : wc_get_order( $post_or_order );
        if ( $order instanceof \WC_Order ) {
            $template = __DIR__ . '/views/order-status-notification-notes.php';
            if (file_exists($template)) {
                include $template;
            }
        }
    }
}

