<?php
namespace OrderDetect\Services;
use OrderDetect\Helper;

class CourierScore {
    protected static $_instance = null;

    public function __construct() {
        if( !Helper::check_license( wp_parse_args( get_option('orderdetect_license') ) ) ) return;
        add_filter('manage_woocommerce_page_wc-orders_columns', array($this, 'add_custom_column_header'), PHP_INT_MAX);
        add_action('manage_woocommerce_page_wc-orders_custom_column', array($this, 'add_custom_column_content'), PHP_INT_MAX, 2);

        add_action('admin_footer', array($this, 'add_modal_html'));
        add_action('woocommerce_admin_order_data_after_billing_address', [$this, 'add_custom_data_edit_order_page'], 9999, 1);
        // add_action('woocommerce_thankyou', [$this, 'save_customer_order_info'], PHP_INT_MAX, 1);

        add_filter( 'manage_edit-shop_order_columns', [$this,'add_custom_order_column'] );
        add_action( 'manage_shop_order_posts_custom_column', [$this,'populate_custom_order_column' ]);
        add_action( 'wp_ajax_save_customer_order_info', array( $this, 'save_customer_order_info' ) );
        add_action( 'wp_ajax_nopriv_save_customer_order_info', array( $this, 'save_customer_order_info' ) );
        add_action( 'woocommerce_thankyou', function ($order_id) {
            ?>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: {
                            'action': 'save_customer_order_info',
                            'order_id': <?php echo $order_id; ?>,
                            'security': '<?php echo wp_create_nonce('process_courier_data_nonce'); ?>'
                        }
                    });
                });
            </script>
            <?php
        });
        
    }

    function add_custom_order_column( $columns ) {
        
        $new_columns = array();

        foreach ($columns as $key => $column) {
            $new_columns[$key] = $column;
            if ('order_number' === $key) {
                $new_columns['courier_scores'] = __('Courier Score', 'courier-score-check');
            }
        }

        return $new_columns;
    }

    function populate_custom_order_column( $column ) {
        
        global $post;
    
        $order_id = $post->ID;

        if ('courier_scores' === $column) {
            $mobile_number = get_billing_phone_by_order_id($order_id);
            $is_already_sync = get_post_meta($mobile_number, $mobile_number . '_order_data', true);


            $class = '';
            $btn_text = '';

            echo '<div class="neuro-handle-score">';
            if (!empty($is_already_sync) && isset($is_already_sync['success_ratio'])) {
                $success_ratio = $is_already_sync['success_ratio'];

                $class = 'neuro-view-customer-info';
                $btn_text = esc_html__('View', 'courier-score-check');
                echo '<div class="neuro-success-ratio">' . $success_ratio . '</div>';
            } else {
                $class = 'neuro-refresh-data';
                $btn_text = esc_html__('Refresh Score', 'courier-score-check');
            }
            echo '<button class="' . esc_attr($class) . '" data-order-id="' . esc_attr($order_id) . '" data-query-type="order">' . $btn_text . '</button>';
            echo '</div';
        }
    }

    public function save_customer_order_info() {

        check_ajax_referer('process_courier_data_nonce', 'security');
        $order_id = isset($_POST['order_id']) ? sanitize_text_field($_POST['order_id']) : '';
        
        if (!$order_id)
            return;

        $mobile_number = get_billing_phone_by_order_id($order_id);
        $order_data = get_post_meta($mobile_number, $mobile_number . '_order_data', true);
        if( isset($order_data) && !empty( $order_data ) ) {
            return;
        }

        $od_steadfast_api_key = get_option('od_steadfast_api_key');
        $od_steadfast_secret_key = get_option('od_steadfast_secret_key');
        $od_pathao_api_username = get_option('od_pathao_api_username');
        $od_pathao_api_password = get_option('od_pathao_api_password');
        $od_paperfly_api_username = get_option('od_paperfly_api_username');
        $od_paperfly_api_password = get_option('od_paperfly_api_password');
        $od_redx_api_key = get_option('od_redx_api_key');

        $courier_data = courier_score_neuro_digital_api_call($mobile_number);
        error_log('Courier Data: '. print_r($courier_data, true));

        if( empty($od_pathao_api_username) && empty($od_pathao_api_password) ) {
            $steadfast = $courier_data['steadfast'];
            error_log('Steadfast Data: '. print_r($steadfast, true));
        } else {
            $steadfast = steadfast_customer_details($mobile_number);
            error_log('OWN Call Steadfast Data: '. print_r($steadfast, true));
        }

        if( empty($od_pathao_api_username) && empty($od_pathao_api_password) ) {
            $pathao = $courier_data['pathao'];
            error_log('Pathao Data: '. print_r($pathao, true));
        } else {
            $pathao = pathao_customer_details($mobile_number);
            error_log('OWN Call Pathao Data: '. print_r($pathao, true)); // Print the Pathao data for debugging or erro
        }

        if( empty($od_paperfly_api_username) && empty($od_paperfly_api_password) ) {
            $paperfly = $courier_data['paperfly'];
            error_log('Paperfly Data: '. print_r($paperfly, true)); // Print the Paperfly data for debugging or erro
        } else {
            $paperfly = paperfly_courier_order_history($mobile_number);
            error_log('OWN Call Paperfly Data: '. print_r($paperfly, true)); // Print the Paperfly data for debugging or erro
        }

        if( empty($od_redx_api_key) ) {
            $redx = $courier_data['redx'];
            error_log('Redx Data: '. print_r($redx, true)); // Print the Redx data for debugging or error
        } else {
            $redx = redex_customer_details($mobile_number);
            error_log('OWN Call Redx Data: '. print_r($redx, true)); // Print the Redx data for debugging or error
        }

        $results = [
            'pathao' => $pathao,
            'steadfast' => $steadfast,
            'paperfly' => $paperfly,
            'redx'    =>  $redx,
        ];

        $success_ratio = calculate_success_ratio($results);
        error_log('Success Ratio: '. $success_ratio);
        $results['success_ratio'] = $success_ratio;

        update_post_meta($mobile_number, $mobile_number . '_order_data', $results);
        wp_send_json_success();
    }

    public function add_custom_data_edit_order_page($order) {

        $order_id = $order->get_id();
        $mobile_number = get_billing_phone_by_order_id($order_id);

        if (!$mobile_number) {
            return 'Phone number not found!';
        }

        $results = get_post_meta($mobile_number, $mobile_number . '_order_data', true);

        if (!is_array($results) || empty($results)) {
            //echo '<p>No order data available.</p>';
            ?>
            <div>
                <button class="neuro-refresh-data" data-order-id="<?php echo esc_attr($order_id); ?>" class="Refress-btn">Refresh Data </button>
            </div> 
            <?php
            return;
        }
    
        if (isset($results['success_ratio'])) {
            unset($results['success_ratio']);
        }
    
        echo neuro_orders_details($results,$order_id);
    
    }

    public function add_custom_column_header($columns) {
        
        $new_columns = array();

        foreach ($columns as $key => $column) {
            $new_columns[$key] = $column;
            if ('order_number' === $key) {
                $new_columns['courier_scores'] = __('', 'courier-score-check');
            }
        }

        return $new_columns;
    }

    public function add_custom_column_content($column, $order) {
        
        if ('courier_scores' === $column) {
            $order_id = $order->get_id();
            $mobile_number = get_billing_phone_by_order_id($order_id);
            $is_already_sync = get_post_meta($mobile_number, $mobile_number . '_order_data', true);


            $class = '';
            $btn_text = '';

            echo '<div class="neuro-handle-score">';
            if (!empty($is_already_sync) && isset($is_already_sync['success_ratio'])) {
                $success_ratio = $is_already_sync['success_ratio'];

                $class = 'neuro-view-customer-info';
                $btn_text = esc_html__('View', 'courier-score-check');
                echo '<div class="neuro-success-ratio">' . $success_ratio . '</div>';
            } else {
                $class = 'neuro-refresh-data';
                $btn_text = esc_html__('Refresh Score', 'courier-score-check');
            }
            echo '<button class="' . esc_attr($class) . '" data-order-id="' . esc_attr($order_id) . '">' . $btn_text . '</button>';
            echo '</div';
        }
    }

    public function add_modal_html() {
        
    ?>
        <style>
            .neuro-view-customer-info {
                width: 50px;
                height: 50px;
                cursor: pointer;
                background: #3572E3;
                border: none;
                color: white;
                border-radius: 50%;
            }

            .neuro-view-customer-info:hover {
                background: #F67A3C;
                transition: 0.5s;
            }

            #neuro-customer-info-modal {
                display: none;
                position: fixed;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background: white;
                padding: 20px;
                border-radius: 5px;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                z-index: 1000;
                width: 670px;
                max-width: 90%;
            }

            #neuro-modal-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.5);
                z-index: 999;
            }

            #neuro-close-modal {
                /* margin-top: 10px;
                padding: 8px 15px;
                background: #0073aa;
                color: white;
                border: none;
                border-radius: 3px;
                cursor: pointer; */
                position: absolute;
                top: 0;
                right: 14px;
                cursor: pointer;
                color: #fb8500;
                border: none;
                background-color: transparent;
                font-size: 25px;
            }

            #neuro-close-modal:hover {
                /* background: #005177; */
                color:rgb(241, 128, 0);
            }

            .neuro {
                display: flex;
            }

        </style>
        <div id="neuro-customer-info-modal">
            <div class="neuro-modal-content neuro">
                <div class="neuro-courier-main-container"> 
                    <div class="neuro-left-panel">
                        <div class="courier-total-container">
                            <div class="total">
                                <h3 id="total-title" class="neuro-total-parcels"></h3>
                                <p>PARCELS</p>
                            </div>
                            <div class="total delivered">
                                <h3 id="neuro-delivered" class="neuro-total-delivered"></h3>
                                <p>DELIVERED</p>
                            </div>
                            <div class="total canceled">
                                <h3 id="neuro-cancel" class="neuro-total-cancelled"></h3>
                                <p>CANCELED</p>
                            </div>
                        </div>
                        <div class="all-courier-data" id="all-courier-data">
                            <div class="courier-data-header">
                                <div class="header-name">
                                    <p>Courier</p>
                                </div>
                                <div class="header-name">
                                    <p>Total</p>
                                </div>
                                <div class="header-name">
                                    <p>Delivered</p>
                                </div>
                                <div class="header-name">
                                    <p>Return</p>
                                </div>
                                <div class="header-name">
                                    <p>Success</p>
                                </div>
                            </div>
                            <div class="courier-data-header courier-table">
                                <div class="header-name courier-name">
                                <img src="<?php echo ORDERDETECT_ASSETS . '/img/sfc.svg' ?>" alt="steadfast">
                                </div>
                                <div class="header-name total-count">
                                    <p id="sfc-total"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="sfc-delivered"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="sfc-return"></p>
                                </div>
                                <div class="header-name">
                                    <p id="sfc-success"></p>
                                </div>
                            </div>
                            <div class="courier-data-header courier-table">
                                <div class="header-name courier-name">
                                <img src="<?php echo ORDERDETECT_ASSETS . '/img/Pathao.svg' ?>" alt="pathao">
                                </div>
                                <div class="header-name total-count">
                                    <p id="pathao-total"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="pathao-delivered"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="pathao-return"></p>
                                </div>
                                <div class="header-name">
                                    <p id="pathao-success"></p>
                                </div>
                            </div>
                            <div class="courier-data-header courier-table">
                                <div class="header-name courier-name">
                                <img src="<?php echo ORDERDETECT_ASSETS . '/img/redx.svg' ?>" alt="redx">
                                </div>
                                <div class="header-name total-count">
                                    <p id="redex-total"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="redex-delivered"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="redex-return"></p>
                                </div>
                                <div class="header-name">
                                    <p id="redex-success"></p>
                                </div>
                            </div>
                            <div class="courier-data-header courier-table">
                                <div class="header-name courier-name">
                                <img src="<?php echo ORDERDETECT_ASSETS . '/img/paperfly.svg' ?>" alt="paperfly">
                                </div>
                                <div class="header-name total-count">
                                    <p id="paperfly-total"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="paperfly-delivered"></p>
                                </div>
                                <div class="header-name total-count">
                                    <p id="paperfly-return"></p>
                                </div>
                                <div class="header-name">
                                    <p id="paperfly-success"></p>
                                </div>
                            </div>     
                        </div>
                    </div>

                    <div class="right-panel">
                        <div class="righ-panel-content">
                            <div class="neuro-logo">
                                <img src="<?php echo ORDERDETECT_ASSETS . '/img/neuro.png' ?>" alt="neuro">
                            </div>
                            <div class="progress-container">
                                <p class="right-panel-ptag">Succes Ratio</p>
                                <div class="progress-circle-popup"></div>
                            </div>
                            <p class="right-panel-ptag" id="requested-phone-number">01853434733</p>
                            <div>
                                <button id="neuro-refresh-id" class="Refress-btn neuro-refresh-data">Refresh Data </button>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <!-- <button ><?php echo esc_html__('Close', 'check-courier-score') ?></button> -->
            <button id="neuro-close-modal" class="order-detect-modal-close order-detect-modal-close-link dashicons dashicons-no-alt">
                <span class="screen-reader-text"><?php esc_html_e( 'Close modal panel', 'order-detect' ); ?></span>
            </button>
        </div>
        <div id="neuro-modal-overlay"></div>
    <?php
    }
    
    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}

