<?php
namespace OrderDetect\Frontend;

use OrderDetect\Helper;

class StoreFront {

    private $api;
    private $settings;
    private $form;

    public function __construct() {
        $this->settings = wp_parse_args(get_option('orderdetect_settings', array(
            'sms_provider' => '',
            'sms_api_key' => array(
                'greenweb' => '',
                'alpha' => '',
                'dianahost' => '',
                'mimsms' => '',
                'bulksmsbd' => ''
            ),
            'mimsms_sender_id' => '',
            'mimsms_username' => '',
            'bulksmsbd_sender_id' => '',
            'enable_otp' => 0,
            'checkout_otp_message' => '',
            'dianahost_sender_id' => '',
            'enable_invoice' => 0,
            'enable_packing_slip' => 0,
            'invoice_packing_slip_logo' => '',
            'business_name' => '',
            'enable_footer_text' => 0,
            'footer_text_heading' => '',
            'footer_text_details' => '',
            'delivery_partner' => '',
            'primary_color' => '#000'
        )));
        add_filter('woocommerce_locate_template', array($this, 'set_locate_template'), PHP_INT_MAX, 3);
        add_action('wp_footer', array($this, 'init_otp_modal_checkout'));
        add_filter('woocommerce_order_button_html', array($this, 'place_order_button_html'), 10);

    }

    public function place_order_button_html($html){
		$html = preg_replace('/onclick="verifyOTPbilling\(10\);return false;"/', '', $html);
		$html = preg_replace('/data-digits_verify="[^"]*"/', '', $html);
		return $html;
    }

    public static function get_plugin_path() {
        return untrailingslashit(plugin_dir_path(__FILE__));
    }

    public function set_locate_template($template, $template_name, $template_path) {

        global $woocommerce;
        $_template = $template;
        if (!$template_path) {
            $template_path = $woocommerce->template_url;
        }

        $plugin_path  = self::get_plugin_path() . '/views/woocommerce/';
        $template = locate_template(
            array(
                $template_path . $template_name,
                $template_name
            )
        );

        if (!$template && file_exists($plugin_path . $template_name))
            $template = $plugin_path . $template_name;

        if (!$template)
            $template = $_template;

        return $template;
    }

    public function init_otp_modal_checkout() {
        if ( is_checkout() && ! empty( $this->settings['enable_otp'] ) ) {
            echo Form::otp_form();
        }

        if ( is_checkout() && 
        (get_option('od_phone_block_enabled') || get_option('od_device_block_enabled') || get_option('od_ip_block_enabled') || ! empty(get_option('blocked_ips')) || ! empty(get_option('blocked_phones')) ) ) {
            echo Form::block_info_popup();
        }
    }
}
