<?php

namespace OrderDetect;

class Assets {

    private $settings;

    function __construct() {
        $this->settings = wp_parse_args(get_option('orderdetect_settings', array(
            'sms_provider' => '',
            'sms_api_key' => array(
                'greenweb' => '',
                'alpha' => '',
                'dianahost' => '',
                'mimsms' => '',
                'bulksmsbd' => ''
            ),
            'mimsms_sender_id' => '',
            'mimsms_username' => '',
            'bulksmsbd_sender_id' => '',
            'enable_otp' => 0,
            'checkout_otp_message' => '',
            'dianahost_sender_id' => '',
            'enable_invoice' => 0,
            'enable_packing_slip' => 0,
            'invoice_packing_slip_logo' => '',
            'business_name' => '',
            'enable_footer_text' => 0,
            'footer_text_heading' => '',
            'footer_text_details' => '',
            'delivery_partner' => '',
            'primary_color' => '#000'
        )));
        add_action('wp_enqueue_scripts', array($this, 'register_assets'));
        add_action('admin_enqueue_scripts', array($this, 'register_admin_assets'));
    }

    public function get_scripts() {
        return array(
            'order-detect-script' => array(
                'src'     => ORDERDETECT_ASSETS . '/js/frontend.js',
                'version' => filemtime(ORDERDETECT_PATH . '/assets/js/frontend.js'),
                'deps'    => array('jquery'),
            ),
        );
    }

    public function get_styles() {
        return array(
            'order-detect-style' => array(
                'src'     => ORDERDETECT_ASSETS . '/css/frontend.css',
                'version' => filemtime(ORDERDETECT_PATH . '/assets/css/frontend.css'),
            ),

        );
    }

    public function register_assets() {

        if( ! Helper::check_license( wp_parse_args( get_option('orderdetect_license') ) ) ) {
            return '';
        }
        
        $scripts = $this->get_scripts();
        $styles  = $this->get_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;
            $type = isset($script['type']) ? $script['type'] : '';

            wp_enqueue_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;
            $type = isset($script['type']) ? $script['type'] : '';

            wp_enqueue_style($handle, $style['src'], $deps, $style['version']);
        }

        wp_localize_script('order-detect-script', 'order_detect', array(
            'ajax_url'  => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('order-detect-nonce'),
            'loader' => '<div class="order-detect-loader"></div>',
            'resend_otp' => __('Resend OTP', 'order-detect'),
            'place_order' => __('Place Order', 'order-detect'),
            'verify' => __('Verify', 'order-detect'),
            'try_again' => __('Try again', 'order-detect'),
            'something_wrong' => __('Something went wrong!', 'order-detect'),
            'settings' => $this->settings
        ));
    }

    public function get_admin_scripts() {
        return array(
            'order-detect-admin-script' => array(
                'src'     => ORDERDETECT_ASSETS . '/js/admin.js',
                'version' => filemtime(ORDERDETECT_PATH . '/assets/js/admin.js'),
                'deps'    => array('jquery'),
            ),
            'toastify-script' => array(
                'src'     => ORDERDETECT_ASSETS . '/lib/toastify/toastify.js',
                'version' => filemtime(ORDERDETECT_PATH . '/assets/lib/toastify/toastify.js'),
                'deps'    => array('order-detect-admin-script'),
            ),
        );
    }

    public function get_admin_styles() {
        return array(
            'orderdetect-admin-style' => array(
                'src'     => ORDERDETECT_ASSETS . '/css/admin.css',
                'version' => filemtime(ORDERDETECT_PATH . '/assets/css/admin.css'),
            ),
            'toastify-style' => array(
                'src'     => ORDERDETECT_ASSETS . '/lib/toastify/toastify.css',
                'version' => filemtime(ORDERDETECT_PATH . '/assets/lib/toastify/toastify.css'),
            ),
        );
    }

    public function register_admin_assets($hook) {
        $screen = get_current_screen();
        $tab = isset($_GET['tab']) ? $_GET['tab'] : '';
        $section = isset($_GET['section']) ? $_GET['section'] : '';

		wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_media();
        $scripts = $this->get_admin_scripts();
        $styles  = $this->get_admin_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;
            $type = isset($script['type']) ? $script['type'] : '';
            wp_enqueue_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;
            $type = isset($script['type']) ? $script['type'] : '';

            wp_enqueue_style($handle, $style['src'], $deps, $style['version']);
        }

        wp_localize_script('order-detect-admin-script', 'order_detect', array(
            'ajax_url'  => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('order-detect-admin-nonce'),
            'nonces' => array(
                'od_packlist' => wp_create_nonce('order-detect'),
            ),
            'activate' => __('Activate', 'order-detect'),
            'deactivate' => __('Deactivate', 'order-detect'),
            'loader' => '<div class="order-detect-loader"></div>',
            'assetsURL' => ORDERDETECT_ASSETS,
            'print_action_url'=>admin_url('?print_od_packinglist=true'),
            'bulk_actions' => array(
                'od_print_invoice',
                'od_download_invoice'
            )
        ));
    }
}
