<div id="order-detect-license" class="order-detect-settings-tab">
    <div id="order-detect-settings-license" class="order-detect-settings-section order-detect-license">
        <table>
            <tbody>
                <tr data-id="license_key" id="order-detect-meta-license_key" class="order-detect-field order-detect-meta-text type-text ">
                    <th class="order-detect-label"></th>
                    <td class="order-detect-control order-detect-license-activate">
                        <?php if (empty($license_key)) { ?>
                            <h2><?php echo __('You are nearly to go!', 'order-detect'); ?></h2>
                            <p><?php echo __('Enter your license key here, to activate OrderDetect, and get automatic updates and premium support.', 'order-detect'); ?></p>
                            <div class="outer">
                                <h4><?php echo __('License Activation', 'order-detect'); ?></h4>
                                <ul>
                                    <li>
                                        <?php printf(__('Log in to <a rel="nofollow" href="%s" target="_blank">your account</a> to get your license key.', 'order-detect'), '#'); ?>
                                    </li>
                                    <li>
                                        <?php printf(__('If you don\'t yet have a license key, get <a rel="nofollow" href="%s" target="_blank">OrderDetect</a> now.', 'order-detect'), '#'); ?>
                                    </li>
                                    <li>
                                        <?php _e(__('Copy the license key from your account and paste it below.', 'order-detect')); ?>
                                    </li>
                                    <li>
                                        <?php _e(__('Click on <strong>"Activate License"</strong> button.', 'order-detect')); ?>
                                    </li>
                                </ul>
                            </div>
                        <?php } ?>

                        <?php if ( ! empty( $license_expires ) ) {
                            $this->license_expire_notice($helper->decrypt_data($license_expires, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV));
                        } ?>
                    </td>
                </tr>
                <tr data-id="license_key" id="order-detect-meta-license_key" class="order-detect-field order-detect-meta-text type-text ">
                    <th class="order-detect-label">
                        <label for="license_key">
                            <?php echo __('License Key', 'order-detect'); ?>
                        </label>
                    </th>
                    <td class="order-detect-control">
                        <div class="order-detect-control-wrapper">
                            <?php if (empty($license_expires)) { ?>
                                <input class="order-detect-settings-field" id="orderdetect_license_key" type="text" name="orderdetect_license_key" value="" placeholder="<?php echo __('Enter your license key', 'order-detect'); ?>">
                            <?php } else { ?>
                                <?php 
                                    $current_date = current_time('mysql');
                                    if( $helper->decrypt_data($license_expires, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV) == "lifetime" ) { ?>
                                        <input class="order-detect-settings-field" id="orderdetect_license_key" type="text" name="orderdetect_license_key" value="<?php echo esc_attr($helper->mask_string($helper->decrypt_data($license_key, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV))); ?>" readonly>
                                    <?php } else if (strtotime($current_date) > strtotime($helper->decrypt_data($license_expires, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV))) { ?>
                                        <input class="order-detect-settings-field" id="orderdetect_license_key" type="text" name="orderdetect_license_key" value="" placeholder="<?php echo __('Enter your new license key', 'order-detect'); ?>">
                                    <?php } else { ?>
                                        <input class="order-detect-settings-field" id="orderdetect_license_key" type="text" name="orderdetect_license_key" value="<?php echo esc_attr($helper->mask_string($helper->decrypt_data($license_key, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV))); ?>" readonly>
                                    <?php } ?>
                            <?php  } ?>
                            <?php
                            $license_expiry = $helper->decrypt_data($license_expires, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV);
                            if ($license_expiry !== "lifetime" && !empty($license_expires)) {
                                $expiry_date = strtotime($license_expiry);
                                $current = strtotime($current_date);
                                $days_until_expiry = ceil(($expiry_date - $current) / (60 * 60 * 24));
                                if ($days_until_expiry <= 7) {
                            ?>
                                <p class="order-detect-field-help">
                                    <a href="https://neurodigitalbd.com/step/order-detect-checkout/" class="button button-primary" target="_blank"><?php echo __('Renew License', 'order-detect'); ?></a>
                                </p>
                            <?php
                                }
                            }
                            ?>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p class="order-detect-license-status"></p>
    <p class="submit">
        <?php echo $this->license_button(); ?>
    </p>
</div>