<?php
/**
 * Template for displaying Order Detect notification notes in the order meta box
 */

// Get order notes related to Order Detect notifications
$args = array(
    'post_id' => $order->get_id(),
    'type' => 'order_note',
    'meta_query' => array(
        array(
            'key' => '_od_notification',
            'value' => '1',
            'compare' => '='
        )
    )
);

$notes = wc_get_order_notes($args);

if (empty($notes)) {
    echo '<p>' . esc_html__('No notification records found.', 'order-detect') . '</p>';
} else {
    echo '<ul class="order-detect-notification-notes">';
        foreach ($notes as $note) {
            echo '<li class="note">';
                echo '<div class="note-content">' . wpautop(wptexturize($note->content)) . '</div>';
                echo '<p class="meta">';
                    echo '<abbr class="exact-date" title="' . esc_attr($note->date_created->date('Y-m-d H:i:s')) . '">';
                        echo esc_html(sprintf(
                            /* translators: %1$s: date created, %2$s: time created */
                            __('%1$s at %2$s', 'order-detect'),
                            $note->date_created->date_i18n(wc_date_format()),
                            $note->date_created->date_i18n(wc_time_format())
                        ));
                    echo '</abbr>';
                echo '</p>';
            echo '</li>';
        }
    echo '</ul>';
}