<?php

namespace OrderDetect\Admin;

use OrderDetect\Helper;

class Main {

	public $_optionName  = 'orderdetect_settings';
	public $_optionGroup = 'orderdetect_options_group';
	public $_defaultOptions = array(
		'sms_provider' => '',
		'sms_api_key' => array(
			'greenweb' => '',
			'alpha' => '',
			'dianahost' => '',
			'mimsms' => '',
			'bulksmsbd' => ''
		),
		'mimsms_sender_id' => '',
		'mimsms_username' => '',
		'bulksmsbd_sender_id' => '',
		'enable_otp' => 0,
		'checkout_otp_message' => '',
		'dianahost_sender_id' => '',
		'enable_invoice' => 0,
		'enable_packing_slip' => 0,
		'invoice_packing_slip_logo' => '',
		'business_name' => '',
		'enable_footer_text' => 0,
		'footer_text_heading' => '',
		'footer_text_details' => '',
		'delivery_partner' => '',
		'primary_color' => '#000'
	);
	private $api;

	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'set_default_options'));
		add_action( 'admin_init', array( $this, 'menu_register_settings'));
		add_filter( 'edd_sl_api_request_veriy_ssl', '__return_false' );
		add_action( 'admin_init', array( $this, 'plugin_update') );
	}

	public function plugin_update() {

		$orderdetect_license = get_option('orderdetect_license');
		$license_key = isset($orderdetect_license['key']) ? $orderdetect_license['key'] : '';
		if( ! empty( $license_key ) ) {
			$updater = new PluginUpdate( ORDERDETECT_STORE_URL, ORDERDETECT_FILE, array(
				'version'      => ORDERDETECT_VERSION,
				'license'      => Helper::decrypt_data($license_key, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV),
				'item_name'    => urlencode(ORDERDETECT_SL_ITEM_NAME),
				// 'item_id'      => 17,
				// 'author' 	   => 'Imran Ahmed',
				'url'          => home_url(),
				'beta'		   => false,

			));
		}
	}

	public function plugin_page()
	{
		$template = __DIR__ . '/views/order-detect-settings.php';
		if (file_exists($template)) {
			$helper = new Helper;
			include $template;
		}
	}

	public function menu_register_settings()
	{
		add_option($this->_optionName, $this->_defaultOptions);
		register_setting($this->_optionGroup, $this->_optionName);
	}

	public function set_default_options()
	{
		return apply_filters('orderdetect_default_options', $this->_defaultOptions);
	}

	public function license_expire_notice($date) {
        if (!empty($date)) {
            $current_date = current_time('mysql');
            if( $date === "lifetime" ) {
                echo '<h2>' . sprintf(__('<span style="color:#3c434a">License expire date:</span> %s', 'order-detect'), $date) . '</h2>';
            } else if (strtotime($current_date) > strtotime($date)) {
                echo '<div class="license-expiration-message" style="color: red; text-align: left;font-size:20px;">' . sprintf(__('Your license has been expired.', 'order-detect')) . '</div>';
            } else {
                $valid_date_str = substr($date, 0, 19);
                $date = new \DateTime($valid_date_str);
                $timestamp = $date->getTimestamp();
                $readable_date = date_i18n('F j, Y, g:i A', $timestamp);
                echo '<h2>' . sprintf(__('<span style="">Expiration Date:</span> %s', 'order-detect'), $readable_date) . '</h2>';
            }
        }
    }

    public function license_button() {

        $setting_options = wp_parse_args(get_option('orderdetect_license'));
        $license_key = array_key_exists('key', $setting_options) ? $setting_options['key'] : '';
        $license_expires = array_key_exists('expires', $setting_options) ? $setting_options['expires'] : '';

        if (!empty($license_key) && !empty($license_expires)) {
            $current_date = current_time('mysql');

            if( Helper::decrypt_data($license_expires, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV) === "lifetime" ) {
                return sprintf(
                    '<button type="button" name="license-deactivate" id="license-deactivate" class="btn-settings order-detect-settings-button"><span class="dashicons dashicons-cloud-saved"></span> %s</button>',
                    __('Deactivate', 'order-detect')
                );
            }
            
            if (strtotime($current_date) > strtotime(Helper::decrypt_data($license_expires, ORDERDETECT_ENCRYPTION_KEY, ORDERDETECT_IV))) {
                return sprintf(
                    '<button type="button" name="license-submit" id="license-submit" class="btn-settings order-detect-settings-button"><span class="dashicons dashicons-cloud-saved"></span> %s</button>',
                    __('Activate New License', 'order-detect')
                );
            }

            return sprintf(
                '<button type="button" name="license-deactivate" id="license-deactivate" class="btn-settings order-detect-settings-button"><span class="dashicons dashicons-cloud-saved"></span> %s</button>',
                __('Deactivate', 'order-detect')
            );
        }

        if (empty($license_key) || empty($license_expires)) {
            return sprintf(
                '<button type="button" name="license-submit" id="license-submit" class="btn-settings order-detect-settings-button"><span class="dashicons dashicons-cloud-saved"></span> %s</button>',
                __('Activate', 'order-detect')
            );
        }
    }
	
}
