(function ($) {
	"use strict";

	$.orderDetect = $.orderDetect || {};
	$(document).ready(function () {
		let activeTab = 'license';
		const qVars = $.orderDetect.get_query_vars();
		if (qVars.page === "order-detect" && qVars.tab && qVars.tab !== "undefined") {
			activeTab = qVars.tab;
		}
		$.orderDetect.setActiveTab(activeTab);
		$.orderDetect.init();
	});

	$.orderDetect.get_query_vars = function () {
		const vars = {};
		window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
			vars[key] = value;
		});
		return vars;
	};

	$.orderDetect.init = function () {
		$.orderDetect.bindEvents();
	};

	$.orderDetect.bindEvents = function () {
		$('.order-detect-settings-button').removeClass('button');
		$(document).on('click', '#enable_otp', function () {
			const sms_provider = $('#sms_provider').val();
			const sms_api_key = $('#sms_api_key').val();
			const dianahost_sender_id = $('#dianahost_sender_id').val();
			const mimsms_sender_id = $('#mimsms_sender_id').val();
			const mimsms_username = $('#mimsms_username').val();
			const bulksmsbd_sender_id = $('#bulksmsbd_sender_id').val();
			
			if (!sms_provider || !sms_api_key) {
				alert('Please select an SMS provider and enter the API key first.');
				return false;
			}
			
			if (sms_provider === 'dianahost' && !dianahost_sender_id) {
				alert('Please enter Dianahost Sender ID first.');
				return false;
			}
			
			if (sms_provider === 'mimsms' && (!mimsms_sender_id || !mimsms_username)) {
				alert('Please enter Mimsms Sender ID and Username first.');
				return false;
			}
			
			if (sms_provider === 'bulksmsbd' && !bulksmsbd_sender_id) {
				alert('Please enter Bulksmsbd Sender ID first.');
				return false;
			}
			
			$.orderDetect.toggleOtpSettings();
		});
		$.orderDetect.toggleOtpSettings();

		$(document).on('click', '#enable_footer_text', function () {
			$.orderDetect.toggleOtpSettings();
		});
	};

	$.orderDetect.settingsTab = function (button) {
		const tabToGo = $(button).data("tab");
		const qVars = $.orderDetect.get_query_vars();
		
		// Check if trying to access Checkout OTP or Order Notification tabs with blank SMS provider
		// if (tabToGo === "otp_settings" || tabToGo === "order_notifications") {
		// 	const sms_provider = $('#sms_provider').val();
		// 	if (!sms_provider || sms_provider === "") {
		// 		alert('Please select an SMS provider before accessing this tab.');
		// 		return false;
		// 	}
		// }
		
		if (qVars.page === "order-detect" && qVars.tab && qVars.tab !== "undefined") {
		}
		$.orderDetect.setActiveTab(tabToGo);
	};

	$(".order-detect-settings-menu li").on("click", function () {
		$.orderDetect.settingsTab(this);
	});

	$.orderDetect.setActiveTab = function (tab) {
		if(!tab){
			tab = 'license';
		}
		$('.order-detect-settings-menu li[data-tab="' + tab + '"]').addClass("active").siblings().removeClass("active");
		$("#order-detect-" + tab).addClass("active").siblings().removeClass("active");
		const qVars = $.orderDetect.get_query_vars();
		if (qVars.page === "order-detect") {
			const baseUrl = window.location.href.split('?')[0] + '?page=order-detect';
			const newUrl = baseUrl + '&tab=' + tab;
			history.replaceState(null, '', newUrl);
		}
	};

	$.orderDetect.toggleOtpSettings = function () {
		const isChecked = $('#enable_otp').is(':checked');
		$('#order-detect-meta-checkout_otp_message').toggle(isChecked);

		const isCheckedFooterText= $('#enable_footer_text').is(':checked');
		$('#order-detect-meta-footer_text_heading').toggle(isCheckedFooterText);
		$('#order-detect-meta-footer_text_details').toggle(isCheckedFooterText);
	};
	
	$(document).on('click', '#license-submit', function(){
		let license_key = $("#orderdetect_license_key").val();
		let $message = $('.order-detect-license-status');
		let that = $(this); 
		if(license_key !=''){
			that.html(order_detect.loader);
			that.prop("disabled",true);
			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: order_detect.ajax_url,
				data: {
					action: 'license_activate',
					security: order_detect.nonce,
					license_key: license_key
				},
				success: function(response, textStatus, jqXHR) {
					var statusCode = jqXHR.status;
					$message.removeClass('order-detect-license-status-success order-detect-license-status-error');
					if (statusCode === 200) {
						$message.addClass(response.class).text(response.message).show();
						that.html('');
						that.html(order_detect.activate);
						that.prop("disabled",false);
						setTimeout(function() {
							location.reload();
						}, 2000);
					} else {
						$message.addClass(response.class).text(response.message).show();
					}
				},
				error: function(jqXHR) {
					var response = jqXHR.responseJSON;
					$message.addClass(response.class).text(response.message).show();
					that.html('');
					that.html(order_detect.activate);
					that.prop("disabled",false);
				}
			});
		}
	});

	$(document).on('click', '#license-deactivate', function(){
		var confirmDeactivation = confirm('Are you sure you want to deactivate the license key?');
        if (!confirmDeactivation) {
            return;
        }
		let $message = $('.order-detect-license-status');
		let that = $(this); 
		that.html(order_detect.loader);
		that.prop("disabled",true);
		$.ajax({
			type: 'POST',
			dataType: 'json',
			url: order_detect.ajax_url,
			data: {
				action: 'license_deactivate',
				security: order_detect.nonce,
			},
			success: function(response, textStatus, jqXHR) {
				var statusCode = jqXHR.status;
				$message.removeClass('order-detect-license-status-success order-detect-license-status-error');
				if (statusCode === 200) {
					$message.addClass(response.class).text(response.message).show();
					that.html('');
					that.html(order_detect.activate);
					that.prop("disabled",false);
					setTimeout(function() {
					location.reload();
					}, 2000);
				} else {
					$message.addClass(response.class).text(response.message).show();
				}
			},
			error: function(jqXHR) {
				var response = jqXHR.responseJSON;
				$message.addClass(response.class).text(response.message).show();
				that.html('');
				that.html(order_detect.activate);
				that.prop("disabled",false);
			}
		});
	});

	$(document).on('click', '.multi-order-preview', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var modalDialog = $(this).closest('td').find('.order-detect-modal-dialog');
        modalDialog.find('.order-detect-modal-content, .order-detect-modal-backdrop').show();
		let maxHeight = ($( window ).height() * 0.75) - 200;
		modalDialog.find('.wc-order-preview-table-wrapper').css({
			'max-height': maxHeight + 'px'
		});
		$('body').addClass('stop-scroll');
    });

    $(document).on('click', '.order-detect-modal-close, .order-detect-modal-backdrop', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var modalDialog = $(this).closest('.order-detect-modal-dialog');
        modalDialog.find('.order-detect-modal-content, .order-detect-modal-backdrop').hide();
		$('body').removeClass('stop-scroll');
    });

    $(document).on('click', '.order-detect-modal-content', function(e) {
        e.stopPropagation();
    });

	var orderIds = jQuery('.multi-order-preview').map(function() {
		// Skip orders that already have data-sync='yes'
		if(jQuery(this).data('sync') !== 'yes') {
			return jQuery(this).data('order-id');
		}
	}).get();

	let currentIndex = 0;
	function loadOrder(orderID) {
		console.log('Loading order:', orderID);
        $.ajax({
            url: order_detect.ajax_url,
            type: 'POST',
			dataType: 'json',
            data: {
                action: 'load_order_by_phone',
                order_id: orderID,
                security: order_detect.nonce,
            },
            success: function(response) {
                if(response.success && response.data) {
					$('#multi-order-preview-'+orderID).text('');
					var dynamicId = 'multi-order-preview-'+orderID

					$('<style>')
						.prop('type', 'text/css')
						.html('#' + dynamicId + '::before { font-family: Dashicons !important; content: "\\f164" !important; }')
						.appendTo('head');
                    $('#multi-order-preview-'+orderID).after(response.data.html);
                }else{
					$('#multi-order-preview-'+orderID).hide();
				}
                 currentIndex++;
                if (currentIndex < orderIds.length) {
                    loadOrder(orderIds[currentIndex]);
                }
            },
            error: function() {
                console.log('Error loading order');
            }
        });
    }

    if (orderIds.length > 0) {
        loadOrder(orderIds[currentIndex]);
    }

	$(document).on('click', '#provider-settings-save-btn', function(e) {
		let button = $(this);
		let sms_provider = $("#sms_provider").val();
		let sms_api_key = $("#sms_api_key").val();
		let dianahost_sender_id = $("#dianahost_sender_id").val();
		let mimsms_sender_id = $("#mimsms_sender_id").val();
		let mimsms_username = $("#mimsms_username").val();
		let bulksmsbd_sender_id = $("#bulksmsbd_sender_id").val();
		let data = {};

		// if (sms_provider === "" || typeof sms_provider === 'undefined' || sms_api_key === '') {
		// 	$("#sms_provider").focus();
			//alert('Please select a SMS Provider and API Key');
		// 	return;
		// }
		if (sms_provider === "" || typeof sms_provider === 'undefined') {
			$("#enable_otp").prop('checked', false);
			$("#checkout_otp_message").hide();
			$('.order-detect-status-alert').each(function() {
				$(this).prop('checked', false);
			});
			$('.order-detect-status-checkbox[type=checkbox]').each(function() {
				var messageRow = $(this).closest('tr').next('tr');
				messageRow.hide();
			});
		}

		data = {
			action: 'save_sms_provider_settings',
			sms_provider:sms_provider,
			sms_api_key:sms_api_key,
			dianahost_sender_id:dianahost_sender_id,
			mimsms_sender_id:mimsms_sender_id,
			mimsms_username:mimsms_username,
			bulksmsbd_sender_id:bulksmsbd_sender_id,
			security: order_detect.nonce,
		}

		if( 'dianahost' === sms_provider && dianahost_sender_id === ''){
			alert('Sender Id is required');
			return;
		}
		if( 'mimsms' === sms_provider && mimsms_sender_id === ''){
			alert('Sender Id is required');
			return;
		}
		if( 'mimsms' === sms_provider && mimsms_username === ''){
			alert('User name is required');
			return;
		}
		if( 'bulksmsbd' === sms_provider && bulksmsbd_sender_id === ''){
			alert('Sender Id is required');
			return;
		}

		if( 'dianahost' === sms_provider && dianahost_sender_id !== ''){
			data[dianahost_sender_id] = dianahost_sender_id
		}
		if( 'mimsms' === sms_provider && mimsms_sender_id !== ''){
			data[mimsms_sender_id] = mimsms_sender_id
		}
		if( 'mimsms' === sms_provider && mimsms_username !== ''){
			data[mimsms_username] = mimsms_username
		}
		if( 'bulksmsbd' === sms_provider && bulksmsbd_sender_id !== ''){
			data[bulksmsbd_sender_id] = bulksmsbd_sender_id
		}
	
		$.ajax({
			url: order_detect.ajax_url,
			type: 'POST',
			dataType: 'json',
			data: data,
			beforeSend: function() {
				button.attr('disabled', true);
				button.text('Saving...');
			},
			success: function(response) {
				if (response.success) {
					$('#sms-balance-show').text(response.data.balance);
					showToast(response.data.message);
				} 
			},
			error: function(e, textStatus, errorThrown) {
				console.log('Error loading order');
				console.log('Error Status: ' + textStatus);
				console.log('Error Thrown: ' + errorThrown);
				console.log('Response Text: ' + e.responseText);
				console.log('Error Object:', e);
				showToast(e.responseText);
			},
			complete: function() {
				button.attr('disabled', false);
				button.text('Save');
			}
		});
	});
	
	$(document).on('click', '#otp-settings-save-btn', function(e) {
		let button = $(this);
		let enable_otp = $("#enable_otp").is(':checked');
		let checkout_otp_message = $("#checkout_otp_message").val().trim();

		if (enable_otp) {
			if (!checkout_otp_message) {
				$("#checkout_otp_message").focus();
				return;
			}
		}
	
		$.ajax({
			url: order_detect.ajax_url,
			type: 'POST',
			dataType: 'json',
			data: {
				action: 'save_otp_setting',
				enable_otp: enable_otp ? 1 : 0,
				checkout_otp_message: checkout_otp_message,
				security: order_detect.nonce,
			},
			beforeSend: function() {
				button.attr('disabled', true);
				button.text('Saving...');
			},
			success: function(response) {
				if (response.success) {
					showToast(response.data.message);
				} 
			},
			error: function(e, textStatus, errorThrown) {
				console.log('Error loading order');
				console.log('Error Status: ' + textStatus);
				console.log('Error Thrown: ' + errorThrown);
				console.log('Response Text: ' + e.responseText);
				console.log('Error Object:', e);
				showToast(e.responseText);
			},
			complete: function() {
				button.attr('disabled', false);
				button.text('Save');
			}
		});
	});

	jQuery(document).ready(function($) {
        $('.order-detect-status-checkbox[type=checkbox]').each(function() {
            var messageRow = $(this).closest('tr').next('tr');
            if (this.checked) {
                messageRow.show();
            } else {
                messageRow.hide();
            }
        });

        $('.order-detect-status-checkbox[type=checkbox]').change(function() {
            const sms_provider = $('#sms_provider').val();
            const sms_api_key = $('#sms_api_key').val();
            const dianahost_sender_id = $('#dianahost_sender_id').val();
            const mimsms_sender_id = $('#mimsms_sender_id').val();
            const mimsms_username = $('#mimsms_username').val();
            const bulksmsbd_sender_id = $('#bulksmsbd_sender_id').val();
            
            if (!sms_provider || !sms_api_key) {
                alert('Please select an SMS provider and enter the API key first.');
                this.checked = false;
                return false;
            }
            
            if (sms_provider === 'dianahost' && !dianahost_sender_id) {
                alert('Please enter Dianahost Sender ID first.');
                this.checked = false;
                return false;
            }
            
            if (sms_provider === 'mimsms' && (!mimsms_sender_id || !mimsms_username)) {
                alert('Please enter Mimsms Sender ID and Username first.');
                this.checked = false;
                return false;
            }
            
            if (sms_provider === 'bulksmsbd' && !bulksmsbd_sender_id) {
                alert('Please enter Bulksmsbd Sender ID first.');
                this.checked = false;
                return false;
            }
            
            var messageRow = $(this).closest('tr').next('tr');
            if (this.checked) {
                messageRow.show();
            } else {
                messageRow.hide();
            }
        });
    });

	$(document).on('click', '#order-alerts-save-btn', function(e) {
		let button = $(this);
		let settingsData = {};
		let hasError = false;

		$('.order-detect-status-alert').each(function() {
			let fieldName = $(this).attr('name');
			if ($(this).is('textarea')) {
				settingsData[fieldName] = $(this).val();
				let checkbox = $(this).closest('tr').prev().find('.order-detect-status-checkbox[type=checkbox]');
				if (checkbox.is(':checked') && !settingsData[fieldName]) {
					hasError = true;
					$(this).focus();
					return false;
				}
			}
			if ($(this).is(':checkbox')) {
				settingsData[fieldName] = $(this).is(':checked') ? 1 : 0;
			}
		});

		if (hasError) {
			return;
		}

		$.ajax({
			url: order_detect.ajax_url,
			type: 'POST',
			dataType: 'json',
			data: {
				action: 'save_order_alerts',
				settings: settingsData,
				security: order_detect.nonce,
			},
			beforeSend: function() {
				button.attr('disabled', true);
				button.text('Saving...');
			},
			success: function(response) {
				if (response.success) {
					showToast(response.data.message);
				}
			},
			error: function(e, textStatus, errorThrown) {
				console.log('Error loading order');
				console.log('Error Status: ' + textStatus);
				console.log('Error Thrown: ' + errorThrown);
				console.log('Response Text: ' + e.responseText);
				console.log('Error Object:', e);
				showToast(e.responseText);
			},
			complete: function() {
				button.attr('disabled', false);
				button.text('Save');
			}
		});
	});

	jQuery(document).ready(function($) {
		$('#sms_provider').on('change', function() {
			var selectedOption = $(this).find('option:selected');
			var apiKey = selectedOption.attr('api_key');
			var smsBalance = selectedOption.attr('balance');
			$('#sms_api_key').val(apiKey);
			$('#sms-balance-show').text(smsBalance);
			if( $(this).val() === "dianahost" ){
				$("#order-detect-meta-dianahost_sender_id").show();
			}  else{
				$("#order-detect-meta-dianahost_sender_id").hide();
			}
			if( $(this).val() === "mimsms" ){
				$("#order-detect-meta-mimsms_sender_id").show();
				$("#order-detect-meta-mimsms_username").show();
			}  else{
				$("#order-detect-meta-mimsms_sender_id").hide();
				$("#order-detect-meta-mimsms_username").hide();
			}
			if( $(this).val() === "bulksmsbd" ){
				$("#order-detect-meta-bulksmsbd_sender_id").show();
			}  else{
				$("#order-detect-meta-bulksmsbd_sender_id").hide();
			}
		});
		$('#sms_provider').trigger('change');
	});
	
	function showToast(text) {
        Toastify({
            text: '<span class="dashicons dashicons-cloud-saved"></span> '+text,
            duration: 1000,
            close: true,
            escapeMarkup: false,
            gravity: "bottom",
            position: "right",
            stopOnFocus: true,
            style: {
              background: "#F3793D",
              color: '#ffff',
            },
            onClick: function(){}
          }).showToast();
          setTimeout(() => {
            document.querySelectorAll('.toast-close img').forEach((img) => {
                img.src = order_detect.assetsURL+"/img/toast-close-button.svg";
            });
            document.querySelectorAll('.toastify').forEach((toast) => {
                toast.classList.add('toastify-bounce');
            });
        }, 0);
    }

	$(document).on('change', '.od_phone_number_status', function(e) {

		let select = $(this);
		let id = select.data('id');
		let status = select.val();

		if( id !== '' ){

			$.ajax({
				url: order_detect.ajax_url,
				type: 'POST',
				dataType: 'json',
				data: {
					action: 'update_phone_number_status',
					id: id,
					is_verified: status,
					security: order_detect.nonce,
				},
				beforeSend: function() {
					select.attr('disabled', true);
				},
				success: function(response) {
					select.prop("disabled",false);
					if (response.success) {
						showToast(response.data.message);
					}
				},
				error: function(e, textStatus, errorThrown) {
					select.prop("disabled",false);
					console.log('Error loading order');
					console.log('Error Status: ' + textStatus);       
					console.log('Error Thrown: ' + errorThrown);         
					console.log('Response Text: ' + e.responseText);     
					console.log('Error Object:', e);
				},
				complete: function() {
					select.prop("disabled",false);
				}		
			});
		}

	});

	if ($.fn.wpColorPicker) {
        $('.od-color-field').wpColorPicker();
    }

})(jQuery);

jQuery(document).ready(function ($) {
	var $modal = $("#neuro-customer-info-modal");
	var $overlay = $("#neuro-modal-overlay");
	var $closeButton = $("#neuro-close-modal");

	$(document).on("click", ".neuro-view-customer-info", function (e) {
		e.preventDefault();

		var thisButton = $(this);
		var order_id = thisButton.data("order-id");
		var query_type = thisButton.data("query-type");

		thisButton.html('<span class="spinner is-active"></span>');

		$.ajax({
			url: order_detect.ajax_url,
			type: "POST",
			data: {
				action: "get_customer_info",
				order_id: order_id,
				query_type: query_type,
				security: order_detect.nonce,
			},
			success: function (response) {
				if (response.success) {
					var pathao = response.data.pathao || {};
					var steadfast = response.data.steadfast || {};
					var paperfly = response.data.paperfly || {};
					var redx = response.data.redx || {};
					var success_ratio = response.data.success_ratio || 0;

					var steadfastParcels = Number(steadfast.total_parcels) || 0;
					var pathaoParcels = Number(pathao.total_parcels) || 0;
					var paperflyParcels = Number(paperfly.total_parcels) || 0;
					var redxParcels = Number(redx.total_parcels) || 0;

					var steadfastDelivered = Number(steadfast.total_delivered) || 0;
					var pathaoDelivered = Number(pathao.total_delivered) || 0;
					var paperflyDelivered = Number(paperfly.total_delivered) || 0;
					var redxDelivered = Number(redx.total_delivered) || 0;

					var steadfastCancelled = Number(steadfast.total_cancelled) || 0;
					var pathaoCancelled = Number(pathao.total_cancelled) || 0;
					var paperflyCancelled = Number(paperfly.total_cancelled) || 0;
					var redxCancelled = Number(redx.total_cancelled) || 0;
					
					var steadfastSuccessRate = steadfast.success_rate || 0;
					var pathaoSuccessRate = pathao.success_rate || 0;
					var paperflySuccessRate = paperfly.success_rate || 0; 
					var redxSuccessRate = redx.success_rate || 0; 

					var total_orders = steadfastParcels + pathaoParcels + paperflyParcels + redxParcels;
					var total_delivered = steadfastDelivered + pathaoDelivered + paperflyDelivered + redxDelivered;
					var total_cancelled = steadfastCancelled + pathaoCancelled + paperflyCancelled + redxCancelled;

					$("#sfc-total").text(steadfastParcels);
					$("#sfc-delivered").text(steadfastDelivered);
					$("#sfc-return").text(steadfastCancelled);
					$("#sfc-success").text(steadfastSuccessRate+'%');

					$("#pathao-total").text(pathaoParcels);
					$("#pathao-delivered").text(pathaoDelivered);
					$("#pathao-return").text(pathaoCancelled);
					$("#pathao-success").text(pathaoSuccessRate+'%');

					$("#paperfly-total").text(paperflyParcels);
					$("#paperfly-delivered").text(paperflyDelivered);
					$("#paperfly-return").text(paperflyCancelled);
					$("#paperfly-success").text(paperflySuccessRate+'%');

					$("#redex-total").text(redxParcels);
					$("#redex-delivered").text(redxDelivered);
					$("#redex-return").text(redxCancelled);
					$("#redex-success").text(redxSuccessRate+'%');
					
					$(".neuro-total-parcels").text(total_orders);
					$(".neuro-total-delivered").text(total_delivered);
					$(".neuro-total-cancelled").text(total_cancelled);
					$("#neuro-total-success").text(success_ratio);
					$("#neuro-refresh-id").attr("data-order-id", order_id);
					$("#requested-phone-number").text(order_id);

					let convertValue = String(success_ratio).replace("%", "");
					$(".progress-circle-popup").attr("data-progress-popup", convertValue);
					document.querySelectorAll('.progress-circle-popup').forEach(el => {
						const value = el.getAttribute('data-progress-popup');
						el.style.background = `conic-gradient(#4492F1 0% ${value}%, #fb8500 ${value}% 100%)`;
					});

					//updateCircleProgress(convertValue);
					// $(".delivery_success_result").each(function () {
					//     if (convertValue >= 95) {
					//         $(this).text('Best');
					//     } else if (convertValue >= 90) {
					//         $(this).text('Excellent');
					//     } else if (convertValue >= 80) {
					//         $(this).text('Very Good');
					//     } else if (convertValue >= 70) {
					//         $(this).text('Better');
					//     } else if (convertValue >= 60) {
					//         $(this).text('Good');
					//     } else if (convertValue >= 50) {
					//         $(this).text('Average');
					//     } else {
					//         $(this).text('Bad');
					//     }
					// });

					thisButton.find('.spinner').remove();
					$modal.show();
					$modal.closest('div').find('.neuro-courier-main-container').css({'width': '100%'}); // Remove spinner from the form if exist
					$overlay.show();
					thisButton.text('View');

				} else {
					alert("Error: " + response.data);
				}
			},
			error: function (xhr, status, error) {
				alert("AJAX Error: " + error);
				thisButton.find('.spinner').remove();
				thisButton.text('View');
			}
		});
	});

	$closeButton.add($overlay).on("click", function () {
		$modal.hide();
		$overlay.hide();
	});

	$(document).on("click", ".neuro-refresh-data", function (e) {
		e.preventDefault();

		var thisButton = $(this);
		var order_id = thisButton.data("order-id");
		var query_type = thisButton.data("query-type");

		thisButton.text("Refreshing...");
		thisButton.attr("disabled", "disabled");

		$.ajax({
			url: order_detect.ajax_url,
			type: "POST",
			data: {
				action: "refresh_order_info",
				order_id: order_id,
				query_type:query_type,
				security: order_detect.nonce,
			},
			success: function (response) {
				console.log(response);
				if (response.success) {
					thisButton.text("Refresh").removeAttr("disabled").css("background-color", "green");
					setTimeout(function () {
						location.reload();
					}, 2000);
				} else {
					thisButton.text("Failed").css("background-color", "red");

					setTimeout(function() {
					thisButton.text("Refreshed").removeAttr("disabled");
						thisButton.text("Refresh").removeAttr("style");
					}, 5000); 
				}
			}
		});
	});

	document.querySelectorAll('.progress-circle').forEach(el => {
		const value = el.getAttribute('data-progress');
		el.style.background = `conic-gradient(#4492F1 0% ${value}%, #fb8500 ${value}% 100%)`;
	});

});

document.addEventListener('DOMContentLoaded', () => {
	document.querySelectorAll('.progress-circle-popup').forEach(el => {
		const value = el.getAttribute('data-progress-popup');
		el.style.background = `conic-gradient(#4492F1 0% ${value}%, #fb8500 ${value}% 100%)`;
	});
});
